/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsOnlineFolderOptions;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsModificationContext
implements AutoCloseable {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static final Log LOG = CmsLog.getLog(CmsModificationContext.class);
    private static CmsObject m_adminCms;
    private static CmsOnlineFolderOptions m_options;
    private static CmsSecurityManager m_securityManager;
    private static final ThreadLocal<CmsModificationContext> threadLocalInstance;
    private Set<CmsUUID> m_ids = new HashSet<CmsUUID>();
    private int m_nestingLevel = 0;
    private CmsRequestContext m_requestContext;
    private Set<CmsResource> m_resources = new HashSet<CmsResource>();

    private CmsModificationContext(CmsRequestContext context) {
        this.m_requestContext = context;
    }

    public static <T> T doWithModificationContext(CmsRequestContext requestContext, FailableSupplier<T, CmsException> runnable) throws CmsException {
        try (CmsModificationContext modContext = CmsModificationContext.acquire(requestContext);){
            Object object = runnable.get();
            return (T)object;
        }
    }

    public static CmsOnlineFolderOptions getOnlineFolderOptions() {
        return m_options;
    }

    public static void initialize(CmsSecurityManager securityManager, CmsObject adminCms, CmsOnlineFolderOptions options) {
        m_securityManager = securityManager;
        m_adminCms = adminCms;
        m_options = options;
    }

    public static boolean isInOnlineFolder(String path) {
        return m_options.getPaths().stream().anyMatch(onlineFolder -> CmsStringUtil.isPrefixPath(onlineFolder, path));
    }

    public static boolean isInstantPublishing() {
        return LOCK.isHeldByCurrentThread();
    }

    protected static CmsModificationContext acquire(CmsRequestContext context) {
        CmsModificationContext instance = threadLocalInstance.get();
        if (instance == null) {
            instance = new CmsModificationContext(context);
            threadLocalInstance.set(instance);
        }
        ++instance.m_nestingLevel;
        return instance;
    }

    public void add(CmsResource resource) {
        if (resource == null) {
            return;
        }
        if (!CmsModificationContext.isInOnlineFolder(resource.getRootPath())) {
            return;
        }
        this.m_resources.add(resource);
    }

    public void addId(CmsUUID structureId) {
        this.m_ids.add(structureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CmsException {
        block22: {
            if (this.m_nestingLevel <= 0) {
                throw new IllegalStateException(CmsModificationContext.class.getSimpleName() + " closed too often!");
            }
            --this.m_nestingLevel;
            if (this.m_nestingLevel == 0) {
                threadLocalInstance.remove();
                Set<CmsResource> resources = this.m_resources;
                if (resources.size() == 0) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing modification context with resources " + resources.toString()));
                    if (this.m_ids.size() > 0) {
                        LOG.debug((Object)("additional ids: " + String.valueOf(this.m_ids)));
                    }
                }
                LOCK.lock();
                try {
                    CmsProject project = this.m_requestContext.getCurrentProject();
                    CmsObject adminCms = OpenCms.initCmsObject(m_adminCms);
                    adminCms.getRequestContext().setCurrentProject(project);
                    HashSet<CmsResource> resources2 = new HashSet<CmsResource>();
                    HashSet<CmsUUID> idsOfResources = new HashSet<CmsUUID>();
                    for (CmsResource resource : resources) {
                        try {
                            idsOfResources.add(resource.getStructureId());
                            resources2.add(adminCms.readResource(resource.getStructureId(), CmsResourceFilter.ALL));
                        }
                        catch (CmsVfsResourceNotFoundException e) {
                            LOG.debug((Object)("Could not find modified resource: " + resource.getRootPath() + " " + String.valueOf(resource.getStructureId())));
                        }
                    }
                    for (CmsUUID id : this.m_ids) {
                        if (idsOfResources.contains(id)) continue;
                        try {
                            CmsResource resource = adminCms.readResource(id, CmsResourceFilter.ALL);
                            if (!CmsModificationContext.isInOnlineFolder(resource.getRootPath())) continue;
                            resources2.add(resource);
                        }
                        catch (CmsVfsResourceNotFoundException e) {
                            LOG.debug((Object)("Could not find modified resource for id: " + String.valueOf(id)));
                        }
                    }
                    CmsPublishList pubList = new CmsPublishList(true, new ArrayList<CmsResource>(resources2), false);
                    pubList.setUserPublishList(true);
                    m_securityManager.fillPublishList(this.m_requestContext, pubList);
                    if (pubList.size() <= 0) break block22;
                    CmsDbContext dbc1 = CmsModificationContext.m_securityManager.m_dbContextFactory.getDbContext(this.m_requestContext);
                    CmsLogReport report = new CmsLogReport(Locale.ENGLISH, CmsModificationContext.class);
                    m_securityManager.publishJob(OpenCms.initCmsObject(m_adminCms, new CmsContextInfo(this.m_requestContext)), dbc1, pubList, report);
                    if (report.hasError() || report.hasWarning()) {
                        Throwable t;
                        for (Object o : report.getErrors()) {
                            if (!(o instanceof Throwable)) continue;
                            t = (Throwable)o;
                            LOG.error((Object)("Report error: " + t.getMessage()), t);
                        }
                        for (Object o : report.getWarnings()) {
                            if (!(o instanceof Throwable)) continue;
                            t = (Throwable)o;
                            LOG.warn((Object)("Report warning: " + t.getMessage()), t);
                        }
                    }
                    CmsDbContext dbc2 = CmsModificationContext.m_securityManager.m_dbContextFactory.getDbContext(this.m_requestContext);
                    try {
                        HashMap<String, Object> eventData = new HashMap<String, Object>();
                        eventData.put("report", report);
                        eventData.put("publishHistoryId", pubList.getPublishHistoryId().toString());
                        eventData.put("projectId", dbc2.currentProject().getUuid());
                        eventData.put("instantPublish", Boolean.TRUE);
                        eventData.put("dbContext", dbc2);
                        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
                        OpenCms.fireCmsEvent(afterPublishEvent);
                        dbc2.clear();
                    }
                    catch (Throwable t) {
                        try {
                            LOG.error((Object)t.getLocalizedMessage(), t);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            dbc2.clear();
                        }
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
    }

    static {
        threadLocalInstance = new ThreadLocal();
    }
}

