/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public final class CmsDbPoolV11 {
    public static final String KEY_DATABASE = "db.";
    public static final String KEY_DATABASE_NAME = "db.name";
    public static final String KEY_DATABASE_POOL = "db.pool";
    public static final String KEY_CONNECT_ATTEMTS = "connects";
    public static final String KEY_CONNECT_WAITS = "wait";
    public static final String KEY_ENTITY_MANAGER_POOL_SIZE = "entityMangerPoolSize";
    public static final String KEY_JDBC_DRIVER = "jdbcDriver";
    public static final String KEY_JDBC_URL = "jdbcUrl";
    public static final String KEY_JDBC_URL_PARAMS = "jdbcUrl.params";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_POOL_DEFAULT = "default";
    public static final String KEY_POOL_URL = "poolUrl";
    public static final String KEY_POOL_USER = "user";
    public static final String KEY_POOL_VFS = "vfs";
    public static final String KEY_USERNAME = "user";
    public static final String OPENCMS_DEFAULT_POOL_NAME = "default";
    public static final String OPENCMS_DEFAULT_POOL_URL = "opencms:default";
    public static final String OPENCMS_URL_PREFIX = "opencms:";
    private static final Log LOG = CmsLog.getLog(CmsDbPoolV11.class);
    private static Map<String, String> testQueries = Maps.newHashMap();
    private String m_poolUrl;
    private HikariDataSource m_dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsDbPoolV11(CmsParameterConfiguration config, String key) throws Exception {
        HikariConfig hikariConf = CmsDbPoolV11.createHikariConfig(config, key);
        this.m_poolUrl = OPENCMS_URL_PREFIX + key;
        this.m_dataSource = new HikariDataSource(hikariConf);
        Connection con = null;
        boolean connect = false;
        int connectionTests = 0;
        int connectionAttempts = config.getInteger("db.pool." + key + ".connects", 10);
        int connectionsWait = config.getInteger("db.pool." + key + ".wait", 5000);
        do {
            try {
                con = this.m_dataSource.getConnection();
                connect = true;
            }
            catch (Exception e) {
                ++connectionTests;
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WAIT_FOR_DB_4", new Object[]{this.getPoolUrl(), this.m_dataSource.getJdbcUrl(), connectionTests, connectionsWait}));
                }
                Thread.sleep(connectionsWait);
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        } while (!connect && connectionTests < connectionAttempts);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JDBC_POOL_2", this.getPoolUrl(), this.m_dataSource.getJdbcUrl()));
        }
    }

    public static HikariConfig createHikariConfig(CmsParameterConfiguration config, String key) {
        HashMap poolMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String suffix = CmsDbPoolV11.getPropertyRelativeSuffix("db.pool." + key, entry.getKey());
            if (suffix == null || CmsStringUtil.isEmptyOrWhitespaceOnly(entry.getValue())) continue;
            String value = entry.getValue().trim();
            poolMap.put(suffix, value);
        }
        Object jdbcUrl = (String)poolMap.get(KEY_JDBC_URL);
        String params = (String)poolMap.get(KEY_JDBC_URL_PARAMS);
        String driver = (String)poolMap.get(KEY_JDBC_DRIVER);
        String user = (String)poolMap.get("user");
        String password = (String)poolMap.get(KEY_PASSWORD);
        String poolName = OPENCMS_URL_PREFIX + key;
        if (params != null && jdbcUrl != null) {
            jdbcUrl = (String)jdbcUrl + params;
        }
        Properties hikariProps = new Properties();
        if (jdbcUrl != null) {
            hikariProps.put(KEY_JDBC_URL, jdbcUrl);
        }
        if (driver != null) {
            hikariProps.put("driverClassName", driver);
        }
        if (user != null) {
            user = OpenCms.getCredentialsResolver().resolveCredential("db_user", user);
            hikariProps.put("username", user);
        }
        if (password != null) {
            password = OpenCms.getCredentialsResolver().resolveCredential("db_password", password);
            hikariProps.put(KEY_PASSWORD, password);
        }
        hikariProps.put("maximumPoolSize", "30");
        for (Map.Entry entry : poolMap.entrySet()) {
            String suffix = CmsDbPoolV11.getPropertyRelativeSuffix("v11", (String)entry.getKey());
            if (suffix == null) continue;
            hikariProps.put(suffix, entry.getValue());
        }
        String configuredTestQuery = (String)hikariProps.get("connectionTestQuery");
        String testQueryForDriver = testQueries.get(driver);
        if (testQueryForDriver != null && CmsStringUtil.isEmptyOrWhitespaceOnly(configuredTestQuery)) {
            hikariProps.put("connectionTestQuery", testQueryForDriver);
        }
        hikariProps.put("registerMbeans", "true");
        HikariConfig result = new HikariConfig(hikariProps);
        result.setPoolName(poolName.replace(":", "_"));
        return result;
    }

    public static String getDefaultDbPoolName() {
        return "default";
    }

    public static String getPropertyRelativeSuffix(String prefix, String str) {
        String realPrefix = prefix + ".";
        if (str.startsWith(realPrefix)) {
            return str.substring(realPrefix.length());
        }
        return null;
    }

    public void close() throws Exception {
        this.m_dataSource.close();
    }

    public int getActiveConnections() {
        return this.m_dataSource.getHikariPoolMXBean().getActiveConnections();
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.m_dataSource.getConnection();
        }
        catch (SQLTimeoutException | SQLTransientConnectionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    public int getIdleConnections() {
        return this.m_dataSource.getHikariPoolMXBean().getIdleConnections();
    }

    public String getPoolUrl() {
        return this.m_poolUrl;
    }

    static {
        testQueries.put("com.ibm.db2.jcc.DB2Driver", "SELECT 1 FROM SYSIBM.SYSDUMMY1");
        testQueries.put("net.sourceforge.jtds.jdbc.Driver", "SELECT 1");
        testQueries.put("oracle.jdbc.driver.OracleDriver", "SELECT 1 FROM DUAL");
        testQueries.put("com.ibm.as400.access.AS400JDBCDriver", "SELECT NOW()");
    }
}

