/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.A_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsStartGallleryPreference
extends A_CmsPreference {
    private String m_value;
    public static final String GALLERY_PREFIX = "gallery.";
    private String m_galleryType;

    public CmsStartGallleryPreference(String galleryType, String value) {
        this.m_galleryType = galleryType;
        this.m_value = value;
    }

    @Override
    public String getDefaultValue() {
        return this.m_value;
    }

    @Override
    public String getName() {
        return GALLERY_PREFIX + this.m_galleryType;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, null, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        return this.getPropertyDefinition();
    }

    @Override
    public String getTab() {
        return "hidden";
    }

    @Override
    public String getValue(CmsDefaultUserSettings userSettings) {
        return userSettings.getStartGallery(this.m_galleryType);
    }

    @Override
    public void setValue(CmsDefaultUserSettings settings, String value) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value) && ((String)value).contains("/") && !((String)value).endsWith("/")) {
            value = (String)value + "/";
        }
        settings.setStartGallery(this.m_galleryType, (String)value);
    }
}

