/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsSitePreference
extends CmsBuiltinPreference {
    private static final String NICE_NAME = "%(key.GUI_PREF_STARTUP_SITE_0)";

    public CmsSitePreference(String name) {
        super(name);
        this.m_basic = true;
    }

    public static String getSiteSelectOptionsStatic(CmsObject cms, Locale locale) {
        List<CmsSite> sites = OpenCms.getSiteManager().getAvailableSites(cms, true, false, cms.getRequestContext().getOuFqn());
        StringBuffer resultBuffer = new StringBuffer();
        Iterator<CmsSite> i = sites.iterator();
        int counter = 0;
        while (i.hasNext()) {
            CmsSite site = i.next();
            Object siteRoot = site.getSiteRoot();
            if (!((String)siteRoot).endsWith("/")) {
                siteRoot = (String)siteRoot + "/";
            }
            if (counter != 0) {
                resultBuffer.append("|");
            }
            resultBuffer.append((String)siteRoot).append(":").append(CmsWorkplace.substituteSiteTitleStatic(site.getTitle(), locale));
            ++counter;
        }
        if (sites.size() < 1) {
            Object siteRoot = cms.getRequestContext().getSiteRoot();
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot((String)siteRoot);
            if (!((String)siteRoot).endsWith("/")) {
                siteRoot = (String)siteRoot + "/";
            }
            String title = "";
            if (site != null) {
                title = site.getTitle();
            }
            resultBuffer.append((String)siteRoot).append(":").append(title);
        }
        return resultBuffer.toString();
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String options = CmsSitePreference.getSiteSelectOptionsStatic(cms, locale);
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", options, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }
}

