/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.A_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsEditorPreference
extends A_CmsPreference {
    public static final String EDITOR_PREFIX = "editor.";
    private String m_value;
    private String m_editorType;

    public CmsEditorPreference(String editorType, String value) {
        this.m_editorType = editorType;
        this.m_value = value;
    }

    @Override
    public String getDefaultValue() {
        return this.m_value;
    }

    @Override
    public String getName() {
        return EDITOR_PREFIX + this.m_editorType;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, null, null, null, null);
        return prop;
    }

    @Override
    public String getTab() {
        return "hidden";
    }

    @Override
    public String getValue(CmsDefaultUserSettings userSettings) {
        return userSettings.getPreferredEditor(this.m_editorType);
    }

    @Override
    public boolean isDisabled(CmsObject cms) {
        return false;
    }

    @Override
    public void setValue(CmsDefaultUserSettings settings, String value) {
        settings.setPreferredEditor(this.m_editorType, value);
    }
}

