/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import org.apache.commons.digester3.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.db.CmsLoginMessage;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsVariablesConfiguration
extends A_CmsXmlConfiguration {
    public static final String N_LOGINMESSAGE = "loginmessage";
    public static final String N_BEFORELOGINMESSAGE = "beforeloginmessage";
    public static final String N_VARIABLES = "variables";
    public static final String N_ENABLED = "enabled";
    public static final String N_MESSAGE = "message";
    public static final String N_TIMESTART = "timeStart";
    public static final String N_TIMEEND = "timeEnd";
    public static final String N_LOGINFORBIDDEN = "loginForbidden";
    public static final String CONFIGURATION_DTD_NAME = "opencms-variables.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-variables.xml";
    private CmsLoginMessage m_loginMessage;
    private CmsLoginMessage m_beforeLoginMessage;

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addObjectCreate("*/loginmessage", CmsLoginMessage.class);
        digester.addBeanPropertySetter("*/loginmessage/enabled");
        digester.addBeanPropertySetter("*/loginmessage/message");
        digester.addBeanPropertySetter("*/loginmessage/loginForbidden");
        digester.addBeanPropertySetter("*/loginmessage/timeStart");
        digester.addBeanPropertySetter("*/loginmessage/timeEnd");
        digester.addSetNext("*/loginmessage", "setLoginMessage");
        digester.addObjectCreate("*/beforeloginmessage", CmsLoginMessage.class);
        digester.addBeanPropertySetter("*/beforeloginmessage/enabled");
        digester.addBeanPropertySetter("*/beforeloginmessage/message");
        digester.addSetNext("*/beforeloginmessage", "setBeforeLoginMessage");
    }

    @Override
    public Element generateXml(Element parent) {
        Element messageElement;
        Element variablesElement = parent.addElement(N_VARIABLES);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_loginMessage = OpenCms.getLoginManager().getLoginMessage();
            this.m_beforeLoginMessage = OpenCms.getLoginManager().getBeforeLoginMessage();
        }
        if (this.m_loginMessage != null) {
            messageElement = variablesElement.addElement(N_LOGINMESSAGE);
            messageElement.addElement(N_ENABLED).addText(String.valueOf(this.m_loginMessage.isEnabled()));
            messageElement.addElement(N_MESSAGE).addCDATA(this.m_loginMessage.getMessage());
            messageElement.addElement(N_LOGINFORBIDDEN).addText(String.valueOf(this.m_loginMessage.isLoginForbidden()));
            if (this.m_loginMessage.getTimeStart() != CmsLoginMessage.DEFAULT_TIME_START) {
                messageElement.addElement(N_TIMESTART).addText(String.valueOf(this.m_loginMessage.getTimeStart()));
            }
            if (this.m_loginMessage.getTimeEnd() != CmsLoginMessage.DEFAULT_TIME_END) {
                messageElement.addElement(N_TIMEEND).addText(String.valueOf(this.m_loginMessage.getTimeEnd()));
            }
        }
        if (this.m_beforeLoginMessage != null) {
            messageElement = variablesElement.addElement(N_BEFORELOGINMESSAGE);
            messageElement.addElement(N_ENABLED).addText(String.valueOf(this.m_beforeLoginMessage.isEnabled()));
            messageElement.addElement(N_MESSAGE).addCDATA(this.m_beforeLoginMessage.getMessage());
        }
        return variablesElement;
    }

    public CmsLoginMessage getBeforeLoginMessage() {
        return this.m_beforeLoginMessage;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsLoginMessage getLoginMessage() {
        return this.m_loginMessage;
    }

    public void setBeforeLoginMessage(CmsLoginMessage message) {
        this.m_beforeLoginMessage = message;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOGINMESSAGE_3", message.isEnabled(), message.isLoginForbidden(), message.getMessage()));
        }
    }

    public void setLoginMessage(CmsLoginMessage message) {
        this.m_loginMessage = message;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOGINMESSAGE_3", message.isEnabled(), message.isLoginForbidden(), message.getMessage()));
        }
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
    }
}

