/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.xml.sax.EntityResolver;

public class CmsParameterStore {
    public static final String A_NAME = "name";
    public static final String A_WEIGHT = "weight";
    public static final double DEFAULT_WEIGHT = 100.0;
    public static final String N_PARAM = "param";
    public static final String PARAM_PARAMFILE = "paramfile";
    private static final CmsParameterStore INSTANCE = new CmsParameterStore();
    private static final Log LOG = CmsLog.getLog(CmsParameterStore.class);

    public static CmsParameterStore getInstance() {
        return INSTANCE;
    }

    public static Map<String, WeightedValue> parse(byte[] data, String source) throws CmsXmlException {
        Document doc;
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(null);
        try {
            doc = CmsXmlUtils.unmarshalHelper(data, (EntityResolver)resolver, true);
        }
        catch (CmsXmlException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            doc = CmsXmlUtils.unmarshalHelper(data, (EntityResolver)resolver, false);
        }
        return CmsParameterStore.parse(doc.getRootElement(), source);
    }

    public static Map<String, WeightedValue> parse(CmsObject cms, String path) throws CmsException {
        CmsFile file = cms.readFile(path, CmsResourceFilter.IGNORE_EXPIRATION);
        return CmsParameterStore.parse(file.getContents(), file.getRootPath());
    }

    public static Map<String, WeightedValue> parse(Element rootElem, String source) {
        double defaultWeight = 100.0;
        String defaultWeightStr = rootElem.attributeValue(A_WEIGHT);
        HashMap<String, WeightedValue> result = new HashMap<String, WeightedValue>();
        if (defaultWeightStr != null) {
            try {
                defaultWeight = Double.parseDouble(defaultWeightStr);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)(source + ":" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        for (Node node : rootElem.selectNodes(N_PARAM)) {
            Double weightObj;
            Element paramElem = (Element)node;
            String nameStr = paramElem.attributeValue(A_NAME);
            String weightStr = paramElem.attributeValue(A_WEIGHT);
            String content = paramElem.getText();
            if (nameStr == null) {
                LOG.error((Object)("Missing name attribute in " + source));
                continue;
            }
            double weight = defaultWeight;
            if (weightStr != null && (weightObj = Doubles.tryParse((String)weightStr)) != null) {
                weight = weightObj;
            }
            WeightedValue val = new WeightedValue(content, weight, source);
            result.put(nameStr, val);
        }
        return result;
    }

    public String getValue(CmsObject cms, String key) {
        WeightedValue val = this.getWeightedValue(cms, key);
        return val == null ? null : val.getValue();
    }

    public WeightedValue getWeightedValue(CmsObject cms, String key) {
        return this.getConfigurations(cms).stream().map(m -> (WeightedValue)m.get(key)).filter(val -> val != null).max((v1, v2) -> Double.compare(v1.getWeight(), v2.getWeight())).orElse(null);
    }

    private List<Map<String, WeightedValue>> getConfigurations(CmsObject cms) {
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        ArrayList<Map<String, WeightedValue>> result = new ArrayList<Map<String, WeightedValue>>();
        for (CmsModule module : modules) {
            String[] paths;
            String paramConfigsStr = module.getParameter(PARAM_PARAMFILE);
            if (paramConfigsStr == null) continue;
            for (String path : paths = paramConfigsStr.trim().split(" *, *")) {
                result.add(this.getConfigurationWithCache(cms, path));
            }
        }
        return result;
    }

    private Map<String, WeightedValue> getConfigurationWithCache(CmsObject cms, String path) {
        String rootPath = cms.getRequestContext().addSiteRoot(path);
        Map<String, WeightedValue> result = (Map<String, WeightedValue>)CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(cms, rootPath);
        if (result == null) {
            try {
                result = CmsParameterStore.parse(cms, path);
            }
            catch (CmsException e) {
                LOG.info((Object)(path + ": " + e.getLocalizedMessage()), (Throwable)e);
                result = new HashMap<String, WeightedValue>();
            }
            CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(cms, rootPath, result);
        }
        return result;
    }

    public static class WeightedValue {
        private String m_source;
        private String m_value;
        private double m_weight;

        public WeightedValue(String value, double weight, String source) {
            this.m_value = value;
            this.m_source = source;
            this.m_weight = weight;
        }

        public String getSource() {
            return this.m_source;
        }

        public String getValue() {
            return this.m_value;
        }

        public double getWeight() {
            return this.m_weight;
        }
    }
}

