/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.dom4j.Element;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.xml.sax.Attributes;

public class CmsElementWithAttrsParamConfigHelper {
    private String[] m_attrs;
    private String m_basePath;
    private Class<?> m_class;
    private String m_name;

    public CmsElementWithAttrsParamConfigHelper(String parentPath, String name, Class<?> cls, String ... attrs) {
        this.m_basePath = parentPath + "/" + name;
        this.m_name = name;
        this.m_class = cls;
        this.m_attrs = attrs;
    }

    public void addRules(Digester digester) {
        digester.addRule(this.m_basePath, new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                I_CmsConfigurationParameterHandler config = (I_CmsConfigurationParameterHandler)CmsElementWithAttrsParamConfigHelper.this.m_class.newInstance();
                for (String attr : CmsElementWithAttrsParamConfigHelper.this.m_attrs) {
                    String attrValue = attributes.getValue(attr);
                    if (attrValue == null) continue;
                    config.addConfigurationParameter(attr, attrValue);
                }
                config.initConfiguration();
                this.getDigester().push((Object)config);
            }

            public void end(String namespace, String name) throws Exception {
                this.getDigester().pop();
            }
        });
    }

    public void generateXml(Element parent, I_CmsConfigurationParameterHandler config) {
        if (config != null) {
            Element elem = parent.addElement(this.m_name);
            for (String attrName : this.m_attrs) {
                String value = config.getConfiguration().get(attrName);
                if (value == null) continue;
                elem.addAttribute(attrName, value);
            }
        }
    }

    public String getBasePath() {
        return this.m_basePath;
    }
}

