/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.opencms.cmis.CmsCmisCallContext;
import org.opencms.cmis.CmsCmisRepository;
import org.opencms.cmis.CmsCmisTypeManager;
import org.opencms.cmis.CmsCmisUtil;
import org.opencms.cmis.I_CmsCmisObjectHelper;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsUUID;

public class CmsCmisRelationHelper
implements I_CmsCmisObjectHelper {
    public static final String RELATION_ID_PREFIX = "REL_";
    public static final Pattern RELATION_PATTERN = Pattern.compile("^REL_([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})_([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})_(.*)$");
    private CmsCmisRepository m_repository;

    public CmsCmisRelationHelper(CmsCmisRepository repository) {
        this.m_repository = repository;
    }

    protected static String createKey(CmsUUID source, CmsUUID target, String relType) {
        return RELATION_ID_PREFIX + String.valueOf(source) + "_" + String.valueOf(target) + "_" + relType;
    }

    protected static CmsRelationType getRelationType(String typeName) {
        for (CmsRelationType relType : CmsRelationType.getAll()) {
            if (!relType.getName().equalsIgnoreCase(typeName)) continue;
            return relType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(CmsCmisCallContext context, String objectId, boolean allVersions) {
        try {
            RelationKey rk = this.parseRelationKey(objectId);
            CmsUUID sourceId = rk.getSourceId();
            CmsObject cms = this.m_repository.getCmsObject(context);
            CmsResource sourceResource = cms.readResource(sourceId);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, sourceResource);
            try {
                CmsRelationFilter relFilter = CmsRelationFilter.ALL.filterType(CmsCmisRelationHelper.getRelationType(rk.getRelType())).filterStructureId(rk.getTargetId());
                cms.deleteRelationsFromResource(sourceResource.getRootPath(), relFilter);
            }
            finally {
                if (wasLocked) {
                    cms.unlockResource(sourceResource);
                }
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
    }

    @Override
    public Acl getAcl(CmsCmisCallContext context, String objectId, boolean onlyBasicPermissions) {
        CmsObject cms = this.m_repository.getCmsObject(context);
        RelationKey rk = this.parseRelationKey(objectId);
        rk.fillRelation(cms);
        return this.collectAcl(cms, rk.getSource(), onlyBasicPermissions);
    }

    @Override
    public AllowableActions getAllowableActions(CmsCmisCallContext context, String objectId) {
        CmsObject cms = this.m_repository.getCmsObject(context);
        RelationKey rk = this.parseRelationKey(objectId);
        rk.fillRelation(cms);
        return this.collectAllowableActions(cms, rk.getSource(), rk.getRelation());
    }

    @Override
    public ObjectData getObject(CmsCmisCallContext context, String objectId, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        CmsObject cms = this.m_repository.getCmsObject(context);
        RelationKey rk = this.parseRelationKey(objectId);
        rk.fillRelation(cms);
        Set<String> filterSet = CmsCmisUtil.splitFilter(filter);
        ObjectData result = this.collectObjectData(context, cms, rk.getSource(), rk.getRelation(), filterSet, includeAllowableActions, includeAcl);
        return result;
    }

    protected Acl collectAcl(CmsObject cms, CmsResource resource, boolean onlyBasic) {
        AccessControlListImpl cmisAcl = new AccessControlListImpl();
        ArrayList cmisAces = new ArrayList();
        cmisAcl.setAces(cmisAces);
        cmisAcl.setExact(Boolean.FALSE);
        return cmisAcl;
    }

    protected AllowableActions collectAllowableActions(CmsObject cms, CmsResource file, CmsRelation relation) {
        try {
            LinkedHashSet<Action> aas = new LinkedHashSet<Action>();
            AllowableActionsImpl result = new AllowableActionsImpl();
            CmsLock lock = cms.getLock(file);
            CmsUser user = cms.getRequestContext().getCurrentUser();
            boolean canWrite = !cms.getRequestContext().getCurrentProject().isOnlineProject() && (lock.isOwnedBy(user) || lock.isLockableBy(user)) && cms.hasPermissions(file, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.DEFAULT);
            CmsCmisUtil.addAction(aas, Action.CAN_GET_PROPERTIES, true);
            CmsCmisUtil.addAction(aas, Action.CAN_DELETE_OBJECT, canWrite && !relation.getType().isDefinedInContent());
            result.setAllowableActions(aas);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    protected ObjectData collectObjectData(CmsCmisCallContext context, CmsObject cms, CmsResource resource, CmsRelation relation, Set<String> filter, boolean includeAllowableActions, boolean includeAcl) {
        ObjectDataImpl result = new ObjectDataImpl();
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        result.setProperties(this.collectProperties(cms, resource, relation, filter, objectInfo));
        if (includeAllowableActions) {
            result.setAllowableActions(this.collectAllowableActions(cms, resource, relation));
        }
        if (includeAcl) {
            result.setAcl(this.collectAcl(cms, resource, true));
            result.setIsExactAcl(Boolean.FALSE);
        }
        if (context.isObjectInfoRequired()) {
            objectInfo.setObject((ObjectData)result);
            context.getObjectInfoHandler().addObjectInfo((ObjectInfo)objectInfo);
        }
        return result;
    }

    protected Properties collectProperties(CmsObject cms, CmsResource resource, CmsRelation relation, Set<String> orgfilter, ObjectInfoImpl objectInfo) {
        CmsCmisTypeManager tm = this.m_repository.getTypeManager();
        if (resource == null) {
            throw new IllegalArgumentException("Resource may not be null.");
        }
        LinkedHashSet<String> filter = orgfilter == null ? null : new LinkedHashSet<String>(orgfilter);
        String typeId = "opencms:" + relation.getType().getName();
        objectInfo.setBaseType(BaseTypeId.CMIS_RELATIONSHIP);
        objectInfo.setTypeId(typeId);
        objectInfo.setContentType(null);
        objectInfo.setFileName(null);
        objectInfo.setHasAcl(false);
        objectInfo.setHasContent(false);
        objectInfo.setVersionSeriesId(null);
        objectInfo.setIsCurrentVersion(true);
        objectInfo.setRelationshipSourceIds(null);
        objectInfo.setRelationshipTargetIds(null);
        objectInfo.setRenditionInfos(null);
        objectInfo.setSupportsDescendants(false);
        objectInfo.setSupportsFolderTree(false);
        objectInfo.setSupportsPolicies(false);
        objectInfo.setSupportsRelationships(false);
        objectInfo.setWorkingCopyId(null);
        objectInfo.setWorkingCopyOriginalId(null);
        try {
            CmsUser user2;
            PropertiesImpl result = new PropertiesImpl();
            String id = this.createKey(relation);
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:objectId", id);
            objectInfo.setId(id);
            String name = this.createReadableName(relation);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:name", name);
            objectInfo.setName(name);
            CmsUUID creatorId = resource.getUserCreated();
            CmsUUID modifierId = resource.getUserLastModified();
            String creatorName = creatorId.toString();
            String modifierName = modifierId.toString();
            try {
                user2 = cms.readUser(creatorId);
                creatorName = user2.getName();
            }
            catch (CmsException user2) {
                // empty catch block
            }
            try {
                user2 = cms.readUser(modifierId);
                modifierName = user2.getName();
            }
            catch (CmsException user3) {
                // empty catch block
            }
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:createdBy", creatorName);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:lastModifiedBy", modifierName);
            objectInfo.setCreatedBy(creatorName);
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:sourceId", relation.getSourceId().toString());
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:targetId", relation.getTargetId().toString());
            GregorianCalendar lastModified = CmsCmisUtil.millisToCalendar(resource.getDateLastModified());
            GregorianCalendar created = CmsCmisUtil.millisToCalendar(resource.getDateCreated());
            CmsCmisUtil.addPropertyDateTime(tm, result, typeId, filter, "cmis:creationDate", created);
            CmsCmisUtil.addPropertyDateTime(tm, result, typeId, filter, "cmis:lastModificationDate", lastModified);
            objectInfo.setCreationDate(created);
            objectInfo.setLastModificationDate(lastModified);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:changeToken", null);
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_RELATIONSHIP.value());
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:objectTypeId", typeId);
            objectInfo.setHasParent(false);
            return result;
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected String createReadableName(CmsRelation relation) {
        return relation.getType().getName() + "[ " + relation.getSourcePath() + " -> " + relation.getTargetPath() + " ]";
    }

    protected RelationKey parseRelationKey(String id) {
        Matcher matcher = RELATION_PATTERN.matcher(id);
        matcher.find();
        CmsUUID src = new CmsUUID(matcher.group(1));
        CmsUUID tgt = new CmsUUID(matcher.group(2));
        String tp = matcher.group(3);
        return new RelationKey(src, tgt, tp);
    }

    String createKey(CmsRelation relation) {
        return CmsCmisRelationHelper.createKey(relation.getSourceId(), relation.getTargetId(), relation.getType().getName());
    }

    public static class RelationKey {
        private CmsRelation m_relation;
        private String m_relType;
        private CmsResource m_source;
        private CmsUUID m_sourceId;
        private CmsUUID m_targetId;

        public RelationKey(CmsUUID sourceId, CmsUUID targetId, String relType) {
            this.m_sourceId = sourceId;
            this.m_targetId = targetId;
            this.m_relType = relType;
        }

        public void fillRelation(CmsObject cms) {
            try {
                this.m_source = cms.readResource(this.m_sourceId);
                List<CmsRelation> relations = cms.getRelationsForResource(this.m_source, CmsRelationFilter.TARGETS.filterStructureId(this.m_targetId).filterType(CmsCmisRelationHelper.getRelationType(this.m_relType)));
                if (relations.isEmpty()) {
                    throw new CmisObjectNotFoundException(this.toString());
                }
                this.m_relation = relations.get(0);
            }
            catch (CmsException e) {
                CmsCmisUtil.handleCmsException(e);
            }
        }

        public CmsRelation getRelation() {
            return this.m_relation;
        }

        public String getRelType() {
            return this.m_relType;
        }

        public CmsResource getSource() {
            return this.m_source;
        }

        public CmsUUID getSourceId() {
            return this.m_sourceId;
        }

        public CmsUUID getTargetId() {
            return this.m_targetId;
        }

        public void setRelType(String relType) {
            this.m_relType = relType;
        }

        public void setSourceId(CmsUUID sourceId) {
            this.m_sourceId = sourceId;
        }

        public void setTargetId(CmsUUID targetId) {
            this.m_targetId = targetId;
        }

        public String toString() {
            return CmsCmisRelationHelper.createKey(this.m_sourceId, this.m_targetId, this.m_relType);
        }
    }
}

