/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import java.util.List;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsEvent;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;

public abstract class CmsVfsCache
implements I_CmsEventListener {
    protected CmsVfsCache() {
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        CmsResource resource = null;
        List<CmsResource> resources = null;
        switch (event.getType()) {
            case 11: 
            case 15: {
                Object change = event.getData().get("change");
                if (change != null && change.equals(0)) {
                    return;
                }
                resource = (CmsResource)event.getData().get("resource");
                this.uncacheResource(resource);
                break;
            }
            case 27: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                this.uncacheResources(resources);
                break;
            }
            case 12: 
            case 22: 
            case 25: {
                resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                this.uncacheResources(resources);
                break;
            }
            case 2: 
            case 17: {
                this.flush(true);
                break;
            }
            case 5: {
                this.flush(true);
                this.flush(false);
                break;
            }
            case 16: {
                this.flush(false);
                break;
            }
        }
    }

    public void shutdown() {
        if (OpenCms.getMemoryMonitor() != null) {
            return;
        }
        this.flush(true);
        this.flush(false);
    }

    protected abstract void flush(boolean var1);

    protected void registerEventListener() {
        OpenCms.addCmsEventListener(this, new int[]{15, 27, 11, 12, 22, 25, 2, 5, 17, 16});
    }

    protected abstract void uncacheResource(CmsResource var1);

    protected void uncacheResources(List<CmsResource> resources) {
        if (resources == null) {
            return;
        }
        int n = resources.size();
        for (int i = 0; i < n; ++i) {
            this.uncacheResource(resources.get(i));
        }
    }
}

