/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.xml.Messages;

public final class CmsMemoryObjectCache
implements I_CmsEventListener {
    private static final Log LOG = CmsLog.getLog(CmsMemoryObjectCache.class);
    private static CmsMemoryObjectCache m_instance;

    private CmsMemoryObjectCache() {
        this.registerEventListener();
    }

    public static CmsMemoryObjectCache getInstance() {
        if (m_instance == null) {
            m_instance = new CmsMemoryObjectCache();
        }
        return m_instance;
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 5: {
                OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.MEMORY_OBJECT);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_FLUSHED_CACHES_0"));
                break;
            }
        }
    }

    public Object getCachedObject(Class<?> owner, String key) {
        key = owner.getName().concat(key);
        return OpenCms.getMemoryMonitor().getCachedMemObject(key);
    }

    public void putCachedObject(Class<?> owner, String key, Object value) {
        key = owner.getName().concat(key);
        OpenCms.getMemoryMonitor().cacheMemObject(key, value);
    }

    protected void registerEventListener() {
        OpenCms.addCmsEventListener(this, new int[]{5});
    }
}

