/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.opencms.util.CmsUUID;

public class CmsUploadWarningTable {
    private Cache<CmsUUID, String> m_cache = CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterWrite(12L, TimeUnit.HOURS).build();

    public void clear() {
        this.m_cache.invalidateAll();
    }

    public String getMessage(CmsUUID id) {
        return (String)this.m_cache.getIfPresent((Object)id);
    }

    public void setMessage(CmsUUID id, String message) {
        if (message != null) {
            this.m_cache.put((Object)id, (Object)message);
        } else {
            this.m_cache.invalidate((Object)id);
        }
    }

    public long size() {
        return this.m_cache.size();
    }
}

