/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.io.Serializable;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.logging.Log;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadTimeoutWatcher;
import org.opencms.ade.upload.Messages;
import org.opencms.gwt.shared.CmsUploadProgessInfo;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;

public class CmsUploadListener
implements ProgressListener,
Serializable {
    private static final Log LOG = CmsLog.getLog(CmsUploadListener.class);
    private static final long serialVersionUID = -6431275569719042836L;
    protected long m_contentLength;
    protected RuntimeException m_exception;
    protected boolean m_exceptionTrhown;
    private long m_bytesRead;
    private int m_delay;
    private boolean m_finished;
    private CmsUUID m_id = new CmsUUID();
    private int m_item;
    private CmsUploadTimeoutWatcher m_watcher;

    public CmsUploadListener(int requestSize) {
        this.m_contentLength = requestSize;
        this.startWatcher();
    }

    public void cancelUpload(CmsUploadException e) {
        this.m_exception = e;
    }

    public long getBytesRead() {
        return this.m_bytesRead;
    }

    public long getContentLength() {
        return this.m_contentLength;
    }

    public RuntimeException getException() {
        return this.m_exception;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public CmsUploadProgessInfo getInfo() {
        if (this.m_finished) {
            return new CmsUploadProgessInfo(this.getItem(), (int)this.getPercent(), CmsUploadProgessInfo.UPLOAD_STATE.finished, this.getContentLength(), this.getBytesRead());
        }
        return new CmsUploadProgessInfo(this.getItem(), (int)this.getPercent(), CmsUploadProgessInfo.UPLOAD_STATE.running, this.getContentLength(), this.getBytesRead());
    }

    public int getItem() {
        return this.m_item;
    }

    public long getPercent() {
        return this.m_contentLength != 0L ? this.m_bytesRead * 100L / this.m_contentLength : 0L;
    }

    public boolean isCanceled() {
        return this.m_exception != null;
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public void setDelay(int delay) {
        this.m_delay = delay;
    }

    public void setFinished(boolean finished) {
        this.m_finished = finished;
    }

    public String toString() {
        return "UUID=" + String.valueOf(this.getId()) + " total=" + this.getContentLength() + " done=" + this.getBytesRead() + " cancelled=" + this.isCanceled();
    }

    public void update(long done, long total, int item) {
        if (this.m_exceptionTrhown) {
            return;
        }
        this.m_bytesRead = done;
        this.m_contentLength = total;
        this.m_item = item;
        if (this.isCanceled()) {
            this.m_exceptionTrhown = true;
            throw this.m_exception;
        }
        if (this.m_delay > 0 && done < total) {
            try {
                Thread.sleep(this.m_delay);
            }
            catch (Exception e) {
                this.m_exception = new RuntimeException(e);
            }
        }
        if (this.getPercent() >= 100L) {
            this.stopWatcher();
        }
    }

    private void startWatcher() {
        if (this.m_watcher == null) {
            try {
                this.m_watcher = new CmsUploadTimeoutWatcher(this);
                this.m_watcher.start();
            }
            catch (Exception e) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_UPLOAD_CREATE_WATCH_DOG_2", this.getId(), e.getMessage()));
            }
        }
    }

    private void stopWatcher() {
        if (this.m_watcher != null) {
            this.m_watcher.cancel();
        }
    }
}

