/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import com.google.common.collect.HashMultimap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadListener;
import org.opencms.ade.upload.CmsVirusScannerLog;
import org.opencms.ade.upload.I_CmsVirusScanner;
import org.opencms.ade.upload.Messages;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsImportFolder;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.I_CmsCollectorPostCreateHandler;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.gwt.shared.CmsUploadRestrictionInfo;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUploadBean
extends CmsJspBean {
    public static final int DEFAULT_UPLOAD_TIMEOUT = 20000;
    public static final String SESSION_ATTRIBUTE_LISTENER_ID = "__CmsUploadBean.LISTENER";
    private static final Log LOG = CmsLog.getLog(CmsUploadBean.class);
    private static Map<CmsUUID, CmsUploadListener> m_listeners = new HashMap<CmsUUID, CmsUploadListener>();
    private CmsMessages m_bundle = Messages.get().getBundle();
    private boolean m_called;
    private List<FileItem> m_multiPartFileItems;
    private Map<String, String[]> m_parameterMap;
    private HashMap<CmsUUID, String> m_resourcesCreated = new HashMap();
    private CmsObject m_rootCms;
    private I_CmsVirusScanner m_scanner;
    private int m_uploadDelay;
    private String m_uploadHook;
    private CmsUploadRestrictionInfo m_uploadRestrictionInfo;
    private HashMultimap<String, String> m_viruses = HashMultimap.create();

    public CmsUploadBean(PageContext context, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        this.init(context, req, res);
        this.m_rootCms = OpenCms.initCmsObject(this.getCmsObject());
        this.m_rootCms.getRequestContext().setSiteRoot("");
        this.m_uploadRestrictionInfo = OpenCms.getWorkplaceManager().getUploadRestriction().getUploadRestrictionInfo(this.m_rootCms);
        if (OpenCms.getWorkplaceManager().isVirusScannerEnabled()) {
            this.m_scanner = OpenCms.getWorkplaceManager().getVirusScanner();
        }
    }

    public static CmsUploadListener getCurrentListener(CmsUUID listenerId) {
        return m_listeners.get(listenerId);
    }

    public static String getNewResourceName(CmsObject cms, String fileName, String folder, boolean keepFileNames) {
        Object newResname = CmsResource.getName(fileName.replace('\\', '/'));
        if (!keepFileNames) {
            newResname = cms.getRequestContext().getFileTranslator().translateResource((String)newResname);
        }
        newResname = folder + (String)newResname;
        return newResname;
    }

    public void setUploadDelay(int uploadDelay) {
        this.m_uploadDelay = uploadDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String start() {
        if (this.m_called) {
            throw new UnsupportedOperationException();
        }
        this.m_called = true;
        CmsUploadListener listener = this.createListener();
        try {
            this.parseRequest(listener);
            this.createResources(listener);
            OpenCms.getSearchManager().updateOfflineIndexes();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            String string = this.generateResponse(Boolean.FALSE, this.getCreationErrorMessage(), this.formatStackTrace(e));
            return string;
        }
        catch (CmsUploadException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            String string = this.generateResponse(Boolean.FALSE, e.getMessage(), this.formatStackTrace(e));
            return string;
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
            String message = this.m_bundle.key("ERR_UPLOAD_UNEXPECTED_0");
            String string = this.generateResponse(Boolean.FALSE, message, this.formatStackTrace(e));
            return string;
        }
        finally {
            this.removeListener(listener.getId());
        }
        return this.generateResponse(Boolean.TRUE, this.m_bundle.key("LOG_UPLOAD_SUCCESS_0"), "");
    }

    private CmsUploadListener createListener() {
        CmsUploadListener listener = new CmsUploadListener(this.getRequest().getContentLength());
        listener.setDelay(this.m_uploadDelay);
        m_listeners.put(listener.getId(), listener);
        this.getRequest().getSession().setAttribute(SESSION_ATTRIBUTE_LISTENER_ID, (Object)listener.getId());
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResources(CmsUploadListener listener) throws CmsException, UnsupportedEncodingException {
        CmsObject cms = this.getCmsObject();
        String[] isRootPathVals = this.m_parameterMap.get("isRootPath");
        if (isRootPathVals != null && isRootPathVals.length > 0 && Boolean.parseBoolean(isRootPathVals[0])) {
            cms = this.m_rootCms;
        }
        String targetFolder = this.getTargetFolder(cms);
        this.m_uploadHook = OpenCms.getWorkplaceManager().getUploadHook(cms, targetFolder);
        if (this.m_scanner != null) {
            this.m_scanner.test();
        }
        List<String> filesToUnzip = this.getFilesToUnzip();
        for (FileItem fileItem : this.m_multiPartFileItems) {
            block19: {
                String fileName;
                byte[] content;
                block20: {
                    List<String> viruses;
                    String originalFileName;
                    block18: {
                        if (fileItem == null || fileItem.isFormField()) continue;
                        content = fileItem.get();
                        fileItem.delete();
                        fileName = this.m_parameterMap.get(fileItem.getFieldName() + "_filename_encoded")[0];
                        originalFileName = this.m_parameterMap.get(fileItem.getFieldName() + "_original_filename_encoded")[0];
                        String context = "(file: " + originalFileName + ")";
                        viruses = this.scan(context, content);
                        fileName = URLDecoder.decode(fileName, "UTF-8");
                        originalFileName = URLDecoder.decode(originalFileName, "UTF-8");
                        if (viruses.size() <= 0) break block18;
                        this.m_viruses.putAll((Object)originalFileName, viruses);
                        break block19;
                    }
                    if (!filesToUnzip.contains(CmsResource.getName(fileName.replace('\\', '/')))) break block20;
                    boolean foundVirus = false;
                    try {
                        ZipFile zip = ((ZipFile.Builder)ZipFile.builder().setByteArray(content)).get();
                        for (ZipArchiveEntry entry : () -> zip.getEntries().asIterator()) {
                            String zipEntryContext;
                            if (entry.isDirectory() || entry.isUnixSymlink() || (viruses = this.scan(zipEntryContext = "(file: " + originalFileName + ", entry: " + entry.getName() + ")", zip, entry)).size() <= 0) continue;
                            foundVirus = true;
                            this.m_viruses.putAll((Object)originalFileName, viruses);
                            break;
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (foundVirus) continue;
                    CmsImportFolder importZip = new CmsImportFolder();
                    try {
                        importZip.importZip(content, targetFolder, cms, false);
                    }
                    catch (Throwable throwable) {
                        for (CmsResource importedResource : importZip.getImportedResources()) {
                            this.m_resourcesCreated.put(importedResource.getStructureId(), importedResource.getName());
                        }
                        throw throwable;
                    }
                    for (CmsResource importedResource : importZip.getImportedResources()) {
                        this.m_resourcesCreated.put(importedResource.getStructureId(), importedResource.getName());
                    }
                    break block19;
                }
                CmsResource importedResource = this.createSingleResource(cms, fileName, targetFolder, content);
                if (importedResource != null) {
                    this.m_resourcesCreated.put(importedResource.getStructureId(), importedResource.getName());
                }
            }
            if (!listener.isCanceled()) continue;
            throw listener.getException();
        }
        String postCreateHandlerStr = this.getPostCreateHandler();
        if (postCreateHandlerStr != null) {
            try {
                CmsPair<String, String> classAndConfig = I_CmsCollectorPostCreateHandler.splitClassAndConfig(postCreateHandlerStr);
                String className = classAndConfig.getFirst();
                String config = classAndConfig.getSecond();
                I_CmsCollectorPostCreateHandler handler = A_CmsResourceCollector.getPostCreateHandler(className);
                for (Map.Entry<CmsUUID, String> resourceEntry : this.m_resourcesCreated.entrySet()) {
                    try {
                        CmsUUID structureId = resourceEntry.getKey();
                        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                        if (resource.isFolder()) continue;
                        handler.onCreate(cms, resource, false, config);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsResource createSingleResource(CmsObject cms, String fileName, String targetFolder, byte[] content) throws CmsException, CmsLoaderException, CmsDbSqlException {
        int slashIndex;
        int backslashIndex;
        String folderRootPath = cms.getRequestContext().addSiteRoot(targetFolder);
        if (!this.m_uploadRestrictionInfo.isUploadEnabled(folderRootPath)) {
            LOG.error((Object)("Upload not enabled for folder " + targetFolder));
            return null;
        }
        String newResname = CmsUploadBean.getNewResourceName(cms, fileName, targetFolder, this.isKeepFileNames());
        CmsResource createdResource = null;
        String title = fileName;
        if (title.lastIndexOf(46) != -1) {
            title = title.substring(0, title.lastIndexOf(46));
        }
        if ((backslashIndex = title.lastIndexOf(92)) != -1) {
            title = title.substring(backslashIndex + 1);
        }
        if ((slashIndex = title.lastIndexOf(47)) != -1) {
            title = title.substring(slashIndex + 1);
        }
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(1);
        CmsProperty titleProp = new CmsProperty();
        titleProp.setName("Title");
        if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
            titleProp.setStructureValue(title);
        } else {
            titleProp.setResourceValue(title);
        }
        properties.add(titleProp);
        int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        if (!cms.existsResource(newResname, CmsResourceFilter.IGNORE_EXPIRATION)) {
            try {
                int resTypeId = OpenCms.getResourceManager().getDefaultTypeForName(newResname).getTypeId();
                createdResource = cms.createResource(newResname, resTypeId, content, properties);
                try {
                    cms.unlockResource(newResname);
                }
                catch (CmsLockException e) {
                    LOG.info((Object)"Couldn't unlock uploaded file", (Throwable)e);
                }
            }
            catch (CmsSecurityException e) {
                createdResource = cms.createResource(newResname, plainId, content, properties);
                cms.unlockResource(newResname);
            }
            catch (CmsDbSqlException sqlExc) {
                cms.lockResource(newResname);
                cms.deleteResource(newResname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                throw sqlExc;
            }
            catch (OutOfMemoryError e) {
                cms.lockResource(newResname);
                cms.deleteResource(newResname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                throw e;
            }
        } else {
            CmsResource res = cms.readResource(newResname, CmsResourceFilter.ALL);
            boolean wasLocked = false;
            try {
                if (!cms.getLock(res).isOwnedBy(cms.getRequestContext().getCurrentUser())) {
                    cms.lockResource(res);
                    wasLocked = true;
                }
                CmsFile file = cms.readFile(res);
                byte[] contents = file.getContents();
                try {
                    cms.replaceResource(newResname, res.getTypeId(), content, null);
                    createdResource = res;
                }
                catch (CmsDbSqlException sqlExc) {
                    file.setContents(contents);
                    cms.writeFile(file);
                    throw sqlExc;
                }
                catch (OutOfMemoryError e) {
                    file.setContents(contents);
                    cms.writeFile(file);
                    throw e;
                }
            }
            finally {
                if (wasLocked) {
                    cms.unlockResource(res);
                }
            }
        }
        return createdResource;
    }

    private CmsResource createTargetFolder(CmsObject cms, String targetFolder) throws CmsException {
        ArrayList<String> parentFolders = new ArrayList<String>();
        String currentFolder = targetFolder;
        while (currentFolder != null && !cms.existsResource(currentFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
            parentFolders.add(currentFolder);
            currentFolder = CmsResource.getParentFolder(currentFolder);
        }
        Collections.reverse(parentFolders);
        CmsResource lastCreated = null;
        CmsResource firstCreated = null;
        for (String parentFolder : parentFolders) {
            CmsResource createdFolder;
            lastCreated = createdFolder = cms.createResource(parentFolder, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
            if (firstCreated != null) continue;
            firstCreated = createdFolder;
        }
        cms.unlockResource(firstCreated);
        return lastCreated;
    }

    private String formatStackTrace(Throwable e) {
        return StringUtils.join((Object[])CmsLog.render(e), (char)'\n');
    }

    private String generateResponse(Boolean success, String message, String stacktrace) {
        JSONObject result = new JSONObject();
        try {
            result.put("success", success);
            result.put("message", message);
            result.put("stacktrace", stacktrace);
            result.put("requestsize", this.getRequest().getContentLength());
            result.put("uploadedFiles", new JSONArray(this.m_resourcesCreated.keySet()));
            result.put("uploadedFileNames", new JSONArray(this.m_resourcesCreated.values()));
            JSONObject virusWarnings = new JSONObject();
            for (String filename : this.m_viruses.keys()) {
                JSONArray viruses = new JSONArray(new ArrayList(this.m_viruses.get((Object)filename)));
                virusWarnings.put(filename, viruses);
            }
            result.put("upload_virus_warnings", virusWarnings);
            if (this.m_uploadHook != null) {
                result.put("uploadHook", this.m_uploadHook);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)this.m_bundle.key("ERR_UPLOAD_JSON_0"), (Throwable)e);
        }
        return result.toString();
    }

    private String getCreationErrorMessage() {
        String message = new String();
        if (!this.m_resourcesCreated.isEmpty()) {
            StringBuffer buf = new StringBuffer(64);
            for (String name : this.m_resourcesCreated.values()) {
                buf.append("<br />");
                buf.append(name);
            }
            message = this.m_bundle.key("ERR_UPLOAD_CREATING_1", buf.toString());
        } else {
            message = this.m_bundle.key("ERR_UPLOAD_CREATING_0");
        }
        return message;
    }

    private List<String> getFilesToUnzip() throws UnsupportedEncodingException {
        String[] filesToUnzip;
        if (this.m_parameterMap.get("upload_unzip_files") != null && (filesToUnzip = this.m_parameterMap.get("upload_unzip_files")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String filename : filesToUnzip) {
                result.add(URLDecoder.decode(filename, "UTF-8"));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private String getPostCreateHandler() {
        String[] values = this.m_parameterMap.get("post_create_handler");
        return values != null && values.length > 0 ? values[0] : null;
    }

    private String getTargetFolder(CmsObject cms) throws CmsException {
        Object targetFolder;
        CmsResource target = cms.readResource("/", CmsResourceFilter.IGNORE_EXPIRATION);
        if (this.m_parameterMap.get("upload_target_folder") != null && !CmsStringUtil.isEmptyOrWhitespaceOnly((String)(targetFolder = this.m_parameterMap.get("upload_target_folder")[0]))) {
            if (cms.existsResource((String)targetFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                CmsResource tmpTarget = cms.readResource((String)targetFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                if (tmpTarget.isFolder()) {
                    target = tmpTarget;
                }
            } else {
                target = this.createTargetFolder(cms, (String)targetFolder);
            }
        }
        if (!((String)(targetFolder = cms.getRequestContext().removeSiteRoot(target.getRootPath()))).endsWith("/")) {
            targetFolder = (String)targetFolder + "/";
        }
        return targetFolder;
    }

    private boolean isKeepFileNames() {
        String[] values = this.m_parameterMap.get("keepFileNames");
        boolean result = values != null && values.length > 0 && Boolean.parseBoolean(values[0]);
        return result;
    }

    private void parseRequest(CmsUploadListener listener) throws Exception {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest())) {
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_NO_MULTIPART_0"));
        }
        this.m_multiPartFileItems = this.readMultipartFileItems(listener);
        if (this.m_multiPartFileItems == null || this.m_multiPartFileItems.isEmpty()) {
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_NO_FILEITEMS_0"));
        }
        this.m_parameterMap = CmsRequestUtil.readParameterMapFromMultiPart(this.getCmsObject().getRequestContext().getEncoding(), this.m_multiPartFileItems);
        listener.setFinished(true);
    }

    private List<FileItem> readMultipartFileItems(CmsUploadListener listener) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        File temp = new File(OpenCms.getSystemInfo().getPackagesRfsPath());
        if (temp.exists() || temp.mkdirs()) {
            factory.setRepository(temp);
        }
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)factory);
        fu.setProgressListener((ProgressListener)listener);
        fu.setHeaderEncoding(this.getRequest().getCharacterEncoding());
        long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCmsObject());
        if (maxFileSizeBytes > 0L) {
            fu.setFileSizeMax(maxFileSizeBytes);
        }
        try {
            return CmsCollectionsGenericWrapper.list(fu.parseRequest(this.getRequest()));
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            Integer actualSize = (int)(e.getActualSize() / 1024L);
            Integer maxSize = (int)(e.getPermittedSize() / 1024L);
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_REQUEST_SIZE_LIMIT_2", actualSize, maxSize), e);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Integer actualSize = (int)(e.getActualSize() / 1024L);
            Integer maxSize = (int)(e.getPermittedSize() / 1024L);
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_FILE_SIZE_LIMIT_3", actualSize, e.getFileName(), maxSize), e);
        }
    }

    private void removeListener(CmsUUID listenerId) {
        this.getRequest().getSession().removeAttribute(SESSION_ATTRIBUTE_LISTENER_ID);
        m_listeners.remove(listenerId);
    }

    private List<String> scan(String context, byte[] data) {
        return this.scanInternal(context, () -> new ByteArrayInputStream(data));
    }

    private List<String> scan(String context, ZipFile zip, ZipArchiveEntry entry) {
        return this.scanInternal(context, () -> zip.getInputStream(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanInternal(String context, InputStreamProvider streamProvider) {
        if (this.m_scanner != null) {
            List<Object> result = null;
            long t1 = System.currentTimeMillis();
            try (InputStream stream = streamProvider.getStream();){
                result = this.m_scanner.scan(stream);
            }
            catch (IOException e) {
                result = Collections.emptyList();
            }
            finally {
                long t2 = System.currentTimeMillis();
                CmsVirusScannerLog.LOG.debug((Object)("Virus scan in context " + context + " took " + (t2 - t1) + "ms"));
            }
            if (result.isEmpty()) {
                CmsVirusScannerLog.LOG.info((Object)("Found no viruses, context=" + context));
            } else {
                CmsVirusScannerLog.LOG.warn((Object)("Found viruses: " + String.valueOf(result) + ", context=" + context + ", user=" + this.getCmsObject().getRequestContext().getCurrentUser().getName()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static interface InputStreamProvider {
        public InputStream getStream() throws IOException;
    }
}

