/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.ade.upload.I_CmsUploadRestriction;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsUploadRestrictionInfo;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;

public class CmsDefaultUploadRestriction
implements I_CmsUploadRestriction {
    public static final String ATTR_UPLOAD_EXTENSIONS = "upload.extensions";
    private static final Log LOG = CmsLog.getLog(CmsDefaultUploadRestriction.class);
    private CmsObject m_cms;
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();
    private Cache<String, CmsUploadRestrictionInfo> m_cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static I_CmsUploadRestriction unrestricted() {
        CmsDefaultUploadRestriction result = new CmsDefaultUploadRestriction();
        result.addConfigurationParameter("/", "enabled:true|types:*");
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public CmsUploadRestrictionInfo getUploadRestrictionInfo(CmsObject cms) {
        if (this.m_cms != null && !OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN) && !cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            try {
                CmsUploadRestrictionInfo result = (CmsUploadRestrictionInfo)this.m_cache.get((Object)"", () -> this.computeUploadRestriction(cms));
                return result;
            }
            catch (ExecutionException e) {
                return new CmsUploadRestrictionInfo.Builder().add("/", "enabled:true|types:*").build();
            }
        }
        return new CmsUploadRestrictionInfo.Builder().add("/", "enabled:true|types:*").build();
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void setAdminCmsObject(CmsObject adminCms) {
        this.m_cms = adminCms;
    }

    private CmsUploadRestrictionInfo computeUploadRestriction(CmsObject cms) {
        CmsUploadRestrictionInfo.Builder builder = new CmsUploadRestrictionInfo.Builder();
        for (Map.Entry<String, String> entry : this.m_config.entrySet()) {
            String string = entry.getKey();
            String value = entry.getValue();
            if (!string.startsWith("/")) continue;
            builder.add(string, value);
        }
        Map<String, String> extensionsMap = OpenCms.getADEManager().getSitemapAttributeValuesByPath(cms, ATTR_UPLOAD_EXTENSIONS);
        for (Map.Entry<String, String> entry : extensionsMap.entrySet()) {
            String path = entry.getKey();
            String typesStr = entry.getValue();
            if (!"".equals(typesStr = typesStr.trim())) {
                Set<String> extensions = Arrays.asList(typesStr.split(",")).stream().map(token -> token.trim().replaceFirst("^\\.", "")).collect(Collectors.toSet());
                builder.add(path, Boolean.TRUE, extensions);
                continue;
            }
            builder.add(path, Boolean.FALSE, new HashSet<String>());
        }
        CmsUploadRestrictionInfo cmsUploadRestrictionInfo = builder.build();
        return cmsUploadRestrictionInfo;
    }
}

