/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.util.CmsUUID;

public class CmsDetailPageTable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4561142050519767250L;
    private Map<CmsUUID, CmsDetailPageInfo> m_infoById = new HashMap<CmsUUID, CmsDetailPageInfo>();
    private Map<String, List<CmsDetailPageInfo>> m_map = new HashMap<String, List<CmsDetailPageInfo>>();

    public CmsDetailPageTable(List<CmsDetailPageInfo> infos) {
        for (CmsDetailPageInfo info : infos) {
            this.m_map.compute(info.getType(), (k, vs) -> vs == null ? new ArrayList() : vs).add(info);
            this.m_infoById.put(info.getId(), info);
        }
    }

    protected CmsDetailPageTable() {
    }

    public void add(CmsDetailPageInfo info) {
        this.m_map.computeIfAbsent(info.getType(), type -> new ArrayList()).add(info);
        this.m_infoById.put(info.getId(), info);
    }

    public boolean canMakeDefault(CmsUUID id) {
        if (this.isDefaultDetailPage(id)) {
            return false;
        }
        CmsDetailPageInfo info = this.m_infoById.get(id);
        return info != null && !info.isInherited();
    }

    public boolean contains(CmsUUID id) {
        return this.m_infoById.containsKey(id);
    }

    public CmsDetailPageTable copy() {
        List<CmsDetailPageInfo> infos = this.toList();
        CmsDetailPageTable result = new CmsDetailPageTable();
        for (CmsDetailPageInfo info : infos) {
            result.add(info);
        }
        return result;
    }

    public CmsDetailPageInfo get(CmsUUID id) {
        return this.m_infoById.get(id);
    }

    public Collection<CmsUUID> getAllIds() {
        return this.m_infoById.keySet();
    }

    public List<CmsDetailPageInfo> getInfosForType(String type) {
        return new ArrayList<CmsDetailPageInfo>(this.m_map.computeIfAbsent(type, k -> new ArrayList()));
    }

    public Status getStatus(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            return Status.noDetailPage;
        }
        String type = info.getType();
        List pagesWithNoQualifier = this.m_map.computeIfAbsent(type, k -> new ArrayList()).stream().filter(detailPage -> detailPage.getQualifier() == null).collect(Collectors.toList());
        int index = pagesWithNoQualifier.indexOf(info);
        if (index == 0) {
            return Status.firstDetailPage;
        }
        return Status.otherDetailPage;
    }

    public boolean isDefaultDetailPage(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            return false;
        }
        CmsDetailPageInfo firstUnqualifiedEntry = this.m_map.get(info.getType()).stream().filter(page -> page.getQualifier() == null).findFirst().orElse(null);
        return firstUnqualifiedEntry != null && firstUnqualifiedEntry.getId().equals(id);
    }

    public int makeDefault(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        CmsDetailPageInfo infoToSave = info;
        if (info.getQualifier() != null) {
            CmsDetailPageInfo info2 = new CmsDetailPageInfo(info.getId(), info.getUri(), info.getType(), null, Collections.emptyList(), info.getIconClasses());
            this.m_infoById.put(id, info2);
            infoToSave = info.isInherited() ? info2.copyAsInherited() : info2;
        }
        String type = info.getType();
        List infos = this.m_map.computeIfAbsent(type, k -> new ArrayList());
        int oldPos = infos.indexOf(info);
        infos.remove(oldPos);
        infos.add(0, infoToSave);
        return oldPos;
    }

    public int remove(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        String type = info.getType();
        List<CmsDetailPageInfo> infos = this.m_map.get(type);
        int pos = infos.indexOf(info);
        infos.remove(pos);
        this.m_infoById.remove(id);
        return pos;
    }

    public int size() {
        return this.m_infoById.size();
    }

    public List<CmsDetailPageInfo> toList() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (String key : this.m_map.keySet()) {
            for (CmsDetailPageInfo info : this.m_map.get(key)) {
                result.add(info);
            }
        }
        return result;
    }

    public static enum Status {
        firstDetailPage,
        noDetailPage,
        otherDetailPage;

    }
}

