/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsSitemapAttributeUpdater {
    private CmsObject m_cms;
    private CmsXmlContent m_sitemapConfig;

    public CmsSitemapAttributeUpdater(CmsObject cms, CmsXmlContent sitemapConfig) {
        this.m_cms = cms;
        this.m_sitemapConfig = sitemapConfig;
    }

    public static Map<String, String> computeUpdatesRelativeToInheritedValues(Map<String, String> newAttributes, CmsADEConfigData config) {
        HashMap<String, String> updates = new HashMap<String, String>();
        CmsADEConfigData parentConfig = config.parent();
        for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
            String parentValue;
            String attrValue;
            String attrName = entry.getKey();
            String updateValue = attrValue = entry.getValue();
            if (parentConfig != null && (parentValue = parentConfig.getAttribute(attrName, null)) != null && parentValue.equals(attrValue)) {
                updateValue = null;
            }
            if ("".equals(attrValue)) {
                updateValue = null;
            }
            updates.put(attrName, updateValue);
        }
        return updates;
    }

    public Map<String, String> getAttributesFromContent() {
        LinkedHashMap<String, String> allValues = new LinkedHashMap<String, String>();
        List<I_CmsXmlContentValue> attributeValues = this.m_sitemapConfig.getValues("Attribute", Locale.ENGLISH);
        for (I_CmsXmlContentValue attr : attributeValues) {
            I_CmsXmlContentValue keyValue = this.m_sitemapConfig.getValue(CmsXmlUtils.concatXpath(attr.getPath(), "Key"), Locale.ENGLISH);
            I_CmsXmlContentValue valueValue = this.m_sitemapConfig.getValue(CmsXmlUtils.concatXpath(attr.getPath(), "Value"), Locale.ENGLISH);
            allValues.put(keyValue.getStringValue(this.m_cms), valueValue.getStringValue(this.m_cms));
        }
        return allValues;
    }

    public CmsXmlContent getContent() {
        return this.m_sitemapConfig;
    }

    public void replaceAttributes(Map<String, String> allValues) {
        while (this.m_sitemapConfig.hasValue("Attribute", Locale.ENGLISH)) {
            this.m_sitemapConfig.removeValue("Attribute", Locale.ENGLISH, 0);
        }
        CmsObject cms = this.m_cms;
        for (Map.Entry<String, String> entry : allValues.entrySet()) {
            I_CmsXmlContentValue newAttrValue = this.m_sitemapConfig.addValue(cms, "Attribute", Locale.ENGLISH, 0);
            I_CmsXmlContentValue newKeyValue = this.m_sitemapConfig.getValue(CmsXmlUtils.concatXpath(newAttrValue.getPath(), "Key"), Locale.ENGLISH);
            I_CmsXmlContentValue newValueValue = this.m_sitemapConfig.getValue(CmsXmlUtils.concatXpath(newAttrValue.getPath(), "Value"), Locale.ENGLISH);
            newKeyValue.setStringValue(cms, entry.getKey());
            newValueValue.setStringValue(cms, entry.getValue());
        }
    }

    public boolean saveAttributesFromEditorDialog(Map<String, String> attributes) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_sitemapConfig.getFile().getRootPath());
        Map<String, String> updates = CmsSitemapAttributeUpdater.computeUpdatesRelativeToInheritedValues(attributes, config);
        return this.updateAttributes(updates);
    }

    public boolean updateAttributes(Map<String, String> attributeUpdates) {
        boolean changed;
        Map<String, String> oldValues = this.getAttributesFromContent();
        LinkedHashMap<String, String> newValues = new LinkedHashMap<String, String>(oldValues);
        for (Map.Entry<String, String> entry : attributeUpdates.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                newValues.put(key, value);
                continue;
            }
            newValues.remove(key);
        }
        boolean bl = changed = !oldValues.equals(newValues);
        if (changed) {
            this.replaceAttributes(newValues);
        }
        return changed;
    }
}

