/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.postupload;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.postupload.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.I_CmsValidationService;
import org.opencms.gwt.shared.CmsValidationResult;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsServerFilenameValidator
implements I_CmsValidationService {
    private static final Log LOG = CmsLog.getLog(CmsServerFilenameValidator.class);

    @Override
    public CmsValidationResult validate(CmsObject cms, String value, String config) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsUUID structureId = new CmsUUID(config);
        try {
            CmsResource parentFolder = cms.readParentFolder(structureId);
            String pathToCheck = CmsStringUtil.joinPaths(cms.getSitePath(parentFolder), value);
            boolean otherFileExists = false;
            try {
                CmsResource res = cms.readResource(pathToCheck, CmsResourceFilter.ALL);
                otherFileExists = !structureId.equals(res.getStructureId());
            }
            catch (CmsPermissionViolationException e) {
                otherFileExists = true;
            }
            catch (Exception e) {
                otherFileExists = false;
            }
            if (otherFileExists) {
                return new CmsValidationResult(Messages.get().getBundle(locale).key("GUI_POSTUPLOAD_FILE_EXISTS_0"));
            }
            return CmsValidationResult.VALIDATION_OK;
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsValidationResult(e.getLocalizedMessage());
        }
    }
}

