/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.CmsResultItemBean;
import org.opencms.ade.galleries.shared.CmsSitemapEntryBean;
import org.opencms.ade.galleries.shared.CmsVfsEntryBean;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.gwt.shared.CmsGalleryContainerInfo;
import org.opencms.gwt.shared.CmsTemplateContextInfo;
import org.opencms.util.CmsStringUtil;

public class CmsGallerySearchBean
implements IsSerializable {
    public static final int DEFAULT_MATCHES_PER_PAGE = 40;
    public static final int DEFAULT_TAB_ID = 0;
    public static final String DICT_NAME = "cms_gallery_search_bean";
    private List<String> m_categories = new ArrayList<String>();
    private CmsGalleryContainerInfo m_containerInfo;
    private long m_dateCreatedEnd = -1L;
    private long m_dateCreatedStart = -1L;
    private long m_dateModifiedEnd = -1L;
    private long m_dateModifiedStart = -1L;
    private boolean m_disablePreview;
    private Set<String> m_folders = new HashSet<String>();
    private List<String> m_galleries = new ArrayList<String>();
    private boolean m_galleriesChanged;
    private I_CmsGalleryProviderConstants.GalleryMode m_galleryMode;
    private String m_galleryStoragePrefix;
    private boolean m_ignoreSearchExclude;
    private boolean m_includeExpired;
    private I_CmsGalleryProviderConstants.GalleryTabId m_initialTabId;
    private int m_lastPage;
    private String m_locale;
    private int m_matchesPerPage;
    private String m_noUploadReason;
    private CmsGalleryDataBean m_originalGalleryData;
    private int m_page;
    private String m_query;
    private String m_referencePath;
    private boolean m_replacedResults;
    private String m_resourcePath;
    private String m_resourceType;
    private int m_resultCount;
    private List<CmsResultItemBean> m_results;
    private CmsGallerySearchScope m_scope;
    private List<String> m_serverSearchTypes = new ArrayList<String>();
    private CmsSitemapEntryBean m_sitemapPreloadData;
    private String m_sortOrder;
    private String m_tabId = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_types.name();
    private CmsTemplateContextInfo m_templateContextInfo;
    private List<String> m_types = new ArrayList<String>();
    private CmsVfsEntryBean m_vfsPreloadData;

    public CmsGallerySearchBean() {
        this.m_matchesPerPage = 40;
        this.m_page = 1;
        this.m_sortOrder = I_CmsGalleryProviderConstants.SortParams.dateLastModified_desc.name();
    }

    public CmsGallerySearchBean(CmsGallerySearchBean searchObj) {
        this.setTypes(searchObj.getTypes());
        this.setGalleries(searchObj.getGalleries());
        this.setFolders(searchObj.getFolders());
        this.setCategories(searchObj.getCategories());
        this.setQuery(searchObj.getQuery());
        this.setLocale(searchObj.getLocale());
        this.setMatchesPerPage(searchObj.getMatchesPerPage());
        this.setSortOrder(searchObj.getSortOrder());
        this.setTabId(searchObj.getTabId());
        this.setPage(searchObj.getPage());
        this.setLastPage(searchObj.getLastPage());
        this.setDateCreatedEnd(searchObj.getDateCreatedEnd());
        this.setDateCreatedStart(searchObj.getDateCreatedStart());
        this.setDateModifiedEnd(searchObj.getDateModifiedEnd());
        this.setDateModifiedStart(searchObj.getDateModifiedStart());
        this.setScope(searchObj.getScope());
        this.setIncludeExpired(searchObj.isIncludeExpired());
        this.setIgnoreSearchExclude(searchObj.isIgnoreSearchExclude());
        this.setGalleryMode(searchObj.getGalleryMode());
        this.setGalleryStoragePrefix(searchObj.getGalleryStoragePrefix());
        this.setServerSearchTypes(searchObj.getServerSearchTypes());
        this.setOriginalGalleryData(searchObj.getOriginalGalleryData());
        this.setReplacedResults(searchObj.hasReplacedResults());
        this.setContainerInfo(searchObj.getContainerInfo());
    }

    public static String getGalleryStorageKey(String prefix, String referenceType) {
        return prefix + "#" + referenceType;
    }

    public void addCategory(String category) {
        if (!this.m_categories.contains(category)) {
            this.m_categories.add(category);
        }
    }

    public void addFolder(String folder) {
        this.m_folders.add(folder);
    }

    public void addGallery(String gallery) {
        if (!this.m_galleries.contains(gallery)) {
            this.m_galleries.add(gallery);
        }
    }

    public void addType(String type) {
        if (!this.m_types.contains(type)) {
            this.m_types.add(type);
        }
    }

    public void clearCategories() {
        this.m_categories.clear();
    }

    public void clearFolders() {
        this.m_folders.clear();
    }

    public void clearFullTextSearch() {
        this.m_query = null;
        this.m_dateCreatedEnd = -1L;
        this.m_dateCreatedStart = -1L;
        this.m_dateModifiedEnd = -1L;
        this.m_dateModifiedStart = -1L;
    }

    public void clearGalleries() {
        this.m_galleries.clear();
    }

    public void clearTypes() {
        this.m_types.clear();
    }

    public List<String> getCategories() {
        return this.m_categories;
    }

    public CmsGalleryContainerInfo getContainerInfo() {
        return this.m_containerInfo;
    }

    public long getDateCreatedEnd() {
        return this.m_dateCreatedEnd;
    }

    public long getDateCreatedStart() {
        return this.m_dateCreatedStart;
    }

    public long getDateModifiedEnd() {
        return this.m_dateModifiedEnd;
    }

    public long getDateModifiedStart() {
        return this.m_dateModifiedStart;
    }

    public Set<String> getFolders() {
        return this.m_folders;
    }

    public List<String> getGalleries() {
        return this.m_galleries;
    }

    public I_CmsGalleryProviderConstants.GalleryMode getGalleryMode() {
        return this.m_galleryMode;
    }

    public String getGalleryStoragePrefix() {
        return this.m_galleryStoragePrefix;
    }

    public I_CmsGalleryProviderConstants.GalleryTabId getInitialTabId() {
        return this.m_initialTabId;
    }

    public int getLastPage() {
        return this.m_lastPage;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public int getMatchesPerPage() {
        return this.m_matchesPerPage;
    }

    public String getNoUploadReason() {
        return this.m_noUploadReason;
    }

    public CmsGalleryDataBean getOriginalGalleryData() {
        return this.m_originalGalleryData;
    }

    public int getPage() {
        if (this.m_page < 1) {
            return 1;
        }
        return this.m_page;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getReferencePath() {
        return this.m_referencePath;
    }

    public String getResourcePath() {
        return this.m_resourcePath;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public int getResultCount() {
        return this.m_resultCount;
    }

    public List<CmsResultItemBean> getResults() {
        return this.m_results;
    }

    public CmsGallerySearchScope getScope() {
        return this.m_scope;
    }

    public List<String> getServerSearchTypes() {
        return this.m_serverSearchTypes;
    }

    public CmsSitemapEntryBean getSitemapPreloadData() {
        return this.m_sitemapPreloadData;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    public String getTabId() {
        return this.m_tabId;
    }

    public CmsTemplateContextInfo getTemplateContextInfo() {
        return this.m_templateContextInfo;
    }

    public List<String> getTypes() {
        return this.m_types;
    }

    public CmsVfsEntryBean getVfsPreloadData() {
        return this.m_vfsPreloadData;
    }

    public boolean hasMore() {
        return this.m_results.size() >= this.m_matchesPerPage && this.m_resultCount > this.m_page * this.m_matchesPerPage && !this.hasReplacedResults();
    }

    public boolean hasReplacedResults() {
        return this.m_replacedResults;
    }

    public boolean haveGalleriesChanged() {
        return this.m_galleriesChanged;
    }

    public boolean isDisablePreview() {
        return this.m_disablePreview;
    }

    public boolean isEmpty() {
        List[] params;
        for (List paramList : params = new List[]{this.m_types, this.m_galleries, this.m_categories, new ArrayList<String>(this.m_folders)}) {
            if (paramList == null || paramList.isEmpty()) continue;
            return false;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_query)) {
            return false;
        }
        List<Long> dates = Arrays.asList(this.m_dateCreatedEnd, this.m_dateCreatedStart, this.m_dateModifiedEnd, this.m_dateModifiedStart);
        for (Long date : dates) {
            if (date == null || date.equals(-1L)) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnoreSearchExclude() {
        return this.m_ignoreSearchExclude;
    }

    public boolean isIncludeExpired() {
        return this.m_includeExpired;
    }

    public void removeCategory(String category) {
        this.m_categories.remove(category);
    }

    public void removeFolder(String folder) {
        this.m_folders.remove(folder);
    }

    public void removeGallery(String gallery) {
        this.m_galleries.remove(gallery);
    }

    public void removeType(String type) {
        this.m_types.remove(type);
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setContainerInfo(CmsGalleryContainerInfo containerInfo) {
        this.m_containerInfo = containerInfo;
    }

    public void setDateCreatedEnd(long dateCreatedEnd) {
        this.m_dateCreatedEnd = dateCreatedEnd;
    }

    public void setDateCreatedStart(long dateCreatedStart) {
        this.m_dateCreatedStart = dateCreatedStart;
    }

    public void setDateModifiedEnd(long dateModifiedEnd) {
        this.m_dateModifiedEnd = dateModifiedEnd;
    }

    public void setDateModifiedStart(long dateModifiedStart) {
        this.m_dateModifiedStart = dateModifiedStart;
    }

    public void setDisablePreview(boolean disablePreview) {
        this.m_disablePreview = disablePreview;
    }

    public void setFolders(Set<String> folders) {
        this.m_folders = folders;
    }

    public void setGalleries(List<String> galleries) {
        this.m_galleries = galleries;
    }

    public void setGalleriesChanged(boolean changed) {
        this.m_galleriesChanged = changed;
    }

    public void setGalleryMode(I_CmsGalleryProviderConstants.GalleryMode galleryMode) {
        this.m_galleryMode = galleryMode;
    }

    public void setGalleryStoragePrefix(String prefix) {
        this.m_galleryStoragePrefix = prefix;
    }

    public void setIgnoreSearchExclude(boolean excludeForPageEditor) {
        this.m_ignoreSearchExclude = excludeForPageEditor;
    }

    public void setIncludeExpired(boolean includeExpired) {
        this.m_includeExpired = includeExpired;
    }

    public void setInitialTabId(I_CmsGalleryProviderConstants.GalleryTabId initialTabId) {
        this.m_initialTabId = initialTabId;
    }

    public void setLastPage(int lastPage) {
        this.m_lastPage = lastPage;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setMatchesPerPage(int matchesPerPage) {
        this.m_matchesPerPage = matchesPerPage;
    }

    public void setNoUploadReason(String noUploadReason) {
        this.m_noUploadReason = noUploadReason;
    }

    public void setOriginalGalleryData(CmsGalleryDataBean originalGalleryData) {
        this.m_originalGalleryData = originalGalleryData;
    }

    public void setPage(int page) {
        this.m_page = page;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    public void setReferencePath(String referencePath) {
        this.m_referencePath = referencePath;
    }

    public void setReplacedResults(boolean replacedResults) {
        this.m_replacedResults = replacedResults;
    }

    public void setResourcePath(String resourcePath) {
        this.m_resourcePath = resourcePath;
    }

    public void setResourceType(String resourceType) {
        this.m_resourceType = resourceType;
    }

    public void setResultCount(int resultCount) {
        this.m_resultCount = resultCount;
    }

    public void setResults(List<CmsResultItemBean> results) {
        this.m_results = results;
    }

    public void setScope(CmsGallerySearchScope scope) {
        this.m_scope = scope;
    }

    public void setServerSearchTypes(List<String> types) {
        this.m_serverSearchTypes = types;
    }

    public void setSitemapPreloadData(CmsSitemapEntryBean preloadData) {
        this.m_sitemapPreloadData = preloadData;
    }

    public void setSortOrder(String sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public void setTabId(String tabId) {
        this.m_tabId = tabId;
    }

    public void setTemplateContextInfo(CmsTemplateContextInfo cmsTemplateContextInfo) {
        this.m_templateContextInfo = cmsTemplateContextInfo;
    }

    public void setTypes(List<String> types) {
        this.m_types = types == null ? new ArrayList<String>() : types;
    }

    public void setVfsPreloadData(CmsVfsEntryBean preloadData) {
        this.m_vfsPreloadData = preloadData;
    }
}

