/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;

public class CmsGalleryFilteredNavTreeBuilder {
    private boolean m_hasMatches;
    private CmsJspNavBuilder m_navBuilder;
    private NavigationNode m_root;

    public CmsGalleryFilteredNavTreeBuilder(CmsObject cms, String rootPath) {
        CmsJspNavBuilder navBuilder;
        this.m_navBuilder = navBuilder = new CmsJspNavBuilder(cms);
        CmsJspNavElement rootNav = navBuilder.getNavigationForResource(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        this.m_root = new NavigationNode(rootNav);
    }

    public NavigationNode getRoot() {
        return this.m_root;
    }

    public boolean hasMatches() {
        return this.m_hasMatches;
    }

    public void initTree(String filter) {
        this.m_root.expandAll();
        this.m_root.matchAll(filter);
        List<NavigationNode> leaves = this.m_root.getLeaves();
        this.m_root.markAsKeep();
        for (NavigationNode leaf : leaves) {
            NavigationNode current;
            leaf.setIsLeaf(true);
            for (current = leaf; current != null && current != this.m_root && !current.isMatch(); current = current.getParent()) {
            }
            while (current != null) {
                current.markAsKeep();
                current = current.getParent();
            }
        }
        this.m_root.removeUnmarkedNodes();
    }

    public class NavigationNode {
        private List<NavigationNode> m_children = Lists.newArrayList();
        private boolean m_isLeaf;
        private boolean m_isMatch;
        private boolean m_keep;
        private CmsJspNavElement m_navElement;
        private NavigationNode m_parent;

        NavigationNode(CmsJspNavElement navElement) {
            this.m_navElement = navElement;
        }

        public List<NavigationNode> getChildren() {
            return this.m_children;
        }

        public CmsJspNavElement getNavElement() {
            return this.m_navElement;
        }

        public boolean isLeaf() {
            return this.m_isLeaf;
        }

        public boolean isMatch() {
            return this.m_isMatch;
        }

        public void removeFromParent() {
            if (this.m_parent != null) {
                this.m_parent.m_children.remove(this);
                this.m_parent = null;
            }
        }

        public void setIsLeaf(boolean isLeaf) {
            this.m_isLeaf = isLeaf;
        }

        public String toString() {
            return this.m_navElement == null ? super.toString() : this.m_navElement.getResource().getRootPath();
        }

        void collectLeaves(List<NavigationNode> results) {
            if (this.m_children.isEmpty()) {
                results.add(this);
            } else {
                for (NavigationNode child : this.m_children) {
                    child.collectLeaves(results);
                }
            }
        }

        void expand() {
            for (CmsJspNavElement navElement : CmsGalleryFilteredNavTreeBuilder.this.m_navBuilder.getNavigationForFolder(this.m_navElement.getResource().getRootPath(), CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
                if (navElement == null || !navElement.isInNavigation()) continue;
                NavigationNode child = new NavigationNode(navElement);
                this.addChild(child);
            }
        }

        void expandAll() {
            this.expand();
            for (NavigationNode child : this.m_children) {
                child.expandAll();
            }
        }

        List<NavigationNode> getLeaves() {
            ArrayList result = Lists.newArrayList();
            this.collectLeaves(result);
            return result;
        }

        NavigationNode getParent() {
            return this.m_parent;
        }

        void markAsKeep() {
            this.m_keep = true;
        }

        void matchAll(String filter) {
            this.m_isMatch = this.matches(filter);
            CmsGalleryFilteredNavTreeBuilder.this.m_hasMatches |= this.m_isMatch;
            for (NavigationNode child : this.m_children) {
                child.matchAll(filter);
            }
        }

        boolean matches(String filter) {
            for (String matchText : new String[]{this.m_navElement.getNavText(), this.m_navElement.getTitle(), this.m_navElement.getDescription()}) {
                if (matchText == null) continue;
                return matchText.toLowerCase().contains(filter.toLowerCase());
            }
            return true;
        }

        void removeUnmarkedNodes() {
            if (!this.m_keep) {
                this.removeFromParent();
            } else {
                for (NavigationNode child : Lists.newArrayList(this.m_children)) {
                    child.removeUnmarkedNodes();
                }
            }
        }

        private void addChild(NavigationNode child) {
            if (child.m_parent != null) {
                throw new IllegalArgumentException();
            }
            this.m_children.add(child);
            child.m_parent = this;
        }
    }
}

