/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.detailpage.CmsDetailPageFilter;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.I_CmsDetailPageHandler;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;

public class CmsPermissiveDetailPageHandler
implements I_CmsDetailPageHandler {
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();

    public static String getDetailPage(CmsADEManager manager, CmsObject cms, String pageRootPath, String originPath, String targetDetailPage) {
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        String resType = manager.getParentFolderType(online, pageRootPath);
        if (resType == null) {
            return null;
        }
        if (targetDetailPage != null && manager.getDetailPages(cms, resType).contains(targetDetailPage)) {
            return targetDetailPage;
        }
        String originRootPath = cms.getRequestContext().addSiteRoot(originPath);
        CmsADEConfigData configData = manager.lookupConfiguration(cms, originRootPath);
        CmsADEConfigData targetConfigData = manager.lookupConfiguration(cms, pageRootPath);
        boolean targetFirst = targetConfigData.isPreferDetailPagesForLocalContents();
        List<CmsADEConfigData> configs = targetFirst ? Arrays.asList(targetConfigData, configData) : Arrays.asList(configData, targetConfigData);
        Iterator<CmsADEConfigData> iterator = configs.iterator();
        while (iterator.hasNext()) {
            CmsDetailPageFilter filter = new CmsDetailPageFilter(cms, pageRootPath);
            CmsADEConfigData config = iterator.next();
            List<CmsDetailPageInfo> pageInfo = config.getDetailPagesForType(resType);
            String uri = filter.filterDetailPages(pageInfo).map(detailPage -> detailPage.getUri()).findFirst().orElse(null);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public Collection<String> getAllDetailPages(CmsObject cms, int resType) throws CmsException {
        if (!OpenCms.getADEManager().isInitialized()) {
            return new ArrayList<String>();
        }
        String typeName = OpenCms.getResourceManager().getResourceType(resType).getTypeName();
        return OpenCms.getADEManager().getDetailPages(cms, typeName);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public String getDetailPage(CmsObject cms, String rootPath, String linkSource, String targetDetailPage) {
        CmsADEManager manager = OpenCms.getADEManager();
        if (!manager.isInitialized()) {
            return null;
        }
        if (rootPath.endsWith(".jsp") || rootPath.startsWith("/system/workplace/")) {
            return null;
        }
        String result = CmsPermissiveDetailPageHandler.getDetailPage(manager, cms, rootPath, linkSource, targetDetailPage);
        if (result == null) {
            return null;
        }
        if (!CmsResource.isFolder(result)) {
            result = CmsResource.getFolderPath(result);
        }
        return result;
    }

    @Override
    public void initConfiguration() {
        this.m_config = CmsParameterConfiguration.unmodifiableVersion(this.m_config);
    }

    @Override
    public void initialize(CmsObject offlineCms, CmsObject onlineCms) {
    }

    @Override
    public boolean isValidDetailPage(CmsObject cms, CmsResource page, CmsResource detailRes) {
        if (OpenCms.getSystemInfo().isRestrictDetailContents()) {
            CmsSite pageSite = OpenCms.getSiteManager().getSiteForRootPath(page.getRootPath());
            CmsSite detailSite = OpenCms.getSiteManager().getSiteForRootPath(detailRes.getRootPath());
            if (pageSite != null && detailSite != null && !pageSite.getSiteRoot().equals(detailSite.getSiteRoot())) {
                return false;
            }
        }
        return OpenCms.getADEManager().isDetailPage(cms, page);
    }
}

