/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.detailpage.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsDetailPageResourceHandler
implements I_CmsResourceInit {
    public static final String ATTR_DETAIL_CONTENT_RESOURCE = "__opencms_detail_content_resource";
    public static final String ATTR_DETAIL_FUNCTION_PAGE = "__opencms_detail_function_page";
    private static final Log LOG = CmsLog.getLog(CmsDetailPageResourceHandler.class);

    public static CmsResource getDetailFunctionPage(ServletRequest req) {
        return (CmsResource)req.getAttribute(ATTR_DETAIL_FUNCTION_PAGE);
    }

    public static CmsUUID getDetailId(ServletRequest req) {
        CmsResource res = CmsDetailPageResourceHandler.getDetailResource(req);
        return res == null ? null : res.getStructureId();
    }

    public static CmsResource getDetailResource(ServletRequest req) {
        return (CmsResource)req.getAttribute(ATTR_DETAIL_CONTENT_RESOURCE);
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException, CmsSecurityException {
        boolean abort;
        boolean bl = abort = resource != null || cms.getRequestContext().getUri().startsWith("/system/");
        if (abort) {
            return resource;
        }
        String path = cms.getRequestContext().getUri();
        path = CmsFileUtil.removeTrailingSeparator(path);
        try {
            cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsSecurityException e) {
            return null;
        }
        catch (CmsException e) {
            // empty catch block
        }
        String detailName = CmsResource.getName(path);
        try {
            CmsUUID detailId = cms.readIdForUrlName(detailName);
            if (detailId != null) {
                CmsResource detailRes = null;
                CmsPermissionViolationException permissionDenied = null;
                try {
                    detailRes = cms.readResource(detailId, CmsResourceFilter.ignoreExpirationOffline(cms));
                }
                catch (CmsPermissionViolationException e) {
                    permissionDenied = e;
                }
                String detailPagePath = CmsResource.getFolderPath(path);
                CmsResource detailPage = cms.readDefaultFile(detailPagePath);
                if (permissionDenied != null) {
                    if (detailPage != null && OpenCms.getADEManager().isDetailPage(cms, detailPage)) {
                        throw permissionDenied;
                    }
                    LOG.debug((Object)("Swallowing CmsPermissionViolationException for detail content because the page [" + detailPagePath + "] is not a detail page.\nDefault file: " + String.valueOf(detailPage) + "\n"), (Throwable)permissionDenied);
                    return null;
                }
                if (!this.isValidDetailPage(cms, detailPage, detailRes)) {
                    return null;
                }
                if (res != null) {
                    req.setAttribute(ATTR_DETAIL_CONTENT_RESOURCE, (Object)detailRes);
                    cms.getRequestContext().setDetailResource(detailRes);
                }
                cms.getRequestContext().setUri(cms.getSitePath(detailPage));
                return detailPage;
            }
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(path));
            for (CmsFunctionReference ref : configData.getFunctionReferences()) {
                if (!detailName.equals(ref.getName()) || ref.getFunctionDefaultPageId() == null) continue;
                CmsResource detailPage = cms.readDefaultFile(CmsResource.getFolderPath(path));
                if (OpenCms.getADEManager().isDetailPage(cms, detailPage)) {
                    if (res != null) {
                        CmsResource functionDefaultPage = cms.readResource(ref.getFunctionDefaultPageId());
                        req.setAttribute(ATTR_DETAIL_FUNCTION_PAGE, (Object)functionDefaultPage);
                        cms.getRequestContext().setDetailResource(functionDefaultPage);
                    }
                    cms.getRequestContext().setUri(cms.getSitePath(detailPage));
                    return detailPage;
                }
                return null;
            }
        }
        catch (CmsPermissionViolationException e) {
            throw e;
        }
        catch (CmsResourceInitException e) {
            throw e;
        }
        catch (CmsVfsResourceNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            String uri = cms.getRequestContext().getUri();
            CmsMessageContainer msg = Messages.get().container("ERR_RESCOURCE_NOT_FOUND_1", uri);
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)msg.key(), e);
            }
            throw new CmsResourceInitException(msg, e);
        }
        return null;
    }

    protected boolean isValidDetailPage(CmsObject cms, CmsResource page, CmsResource detailRes) {
        return OpenCms.getADEManager().getDetailPageHandler().isValidDetailPage(cms, page, detailRes);
    }
}

