/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencms.util.CmsUUID;

public class CmsDetailPageInfo
implements Serializable {
    public static final String FUNCTION_PREFIX = "function@";
    public static final String QUALIFIER_SEPARATOR = "|";
    private static final long serialVersionUID = 7714334294682534900L;
    private String m_iconClasses;
    private CmsUUID m_id;
    private boolean m_inherited;
    private String m_qualifier;
    private String m_type;
    private String m_uri;
    private List<CmsUUID> m_folders;

    public CmsDetailPageInfo(CmsUUID id, String uri, String type, String qualifier, List<CmsUUID> folders, String iconClasses) {
        this.m_id = id;
        this.m_type = type;
        List<CmsUUID> list = this.m_folders = folders != null ? new ArrayList<CmsUUID>(folders) : new ArrayList();
        if (this.m_type != null && this.m_type.indexOf(QUALIFIER_SEPARATOR) != -1) {
            throw new RuntimeException("Error: Qualifier separator '|' may not be part of detail page type: " + type);
        }
        this.m_qualifier = qualifier;
        this.m_uri = uri;
        this.m_iconClasses = iconClasses;
    }

    protected CmsDetailPageInfo() {
    }

    public static String removeFunctionPrefix(String name) {
        return name.replaceFirst("^function@", "");
    }

    public CmsDetailPageInfo copyAsInherited() {
        CmsDetailPageInfo result = new CmsDetailPageInfo(this.m_id, this.m_uri, this.m_type, this.m_qualifier, this.m_folders, this.m_iconClasses);
        result.m_inherited = true;
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CmsDetailPageInfo) {
            CmsDetailPageInfo info = (CmsDetailPageInfo)obj;
            result = this.toString().equals(info.toString());
        }
        return result;
    }

    public String getDisplayType() {
        return this.m_type != null ? CmsDetailPageInfo.removeFunctionPrefix(this.m_type) : "";
    }

    public List<CmsUUID> getFolders() {
        return Collections.unmodifiableList(this.m_folders);
    }

    public String getIconClasses() {
        return this.m_iconClasses;
    }

    public String getIconType() {
        if (this.m_type.startsWith(FUNCTION_PREFIX)) {
            return "function";
        }
        return this.m_type;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getMergeKey() {
        return this.getQualifiedType() + QUALIFIER_SEPARATOR + this.m_folders.toString();
    }

    public String getQualifiedType() {
        if (this.m_qualifier != null) {
            return this.getType() + QUALIFIER_SEPARATOR + this.getQualifier();
        }
        return this.getType();
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUri() {
        return this.m_uri;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isDefaultDetailPage() {
        return "##DEFAULT##".equals(this.getType());
    }

    public boolean isInherited() {
        return this.m_inherited;
    }

    public String toString() {
        return this.m_type + QUALIFIER_SEPARATOR + this.m_qualifier + QUALIFIER_SEPARATOR + String.valueOf(this.m_folders) + ":" + String.valueOf(this.m_id) + this.m_uri;
    }
}

