/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsPath;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsDetailPageFilter {
    public static final String PREFIX_CATEGORY = "category:";
    public static final String QUALIFIER_FOLDERS = "folders";
    private static final Log LOG = CmsLog.getLog(CmsDetailPageFilter.class);
    private Set<CmsPath> m_categories;
    private String m_categoryBase;
    private CmsObject m_cms;
    private String m_path;
    private CmsResource m_resource;

    public CmsDetailPageFilter(CmsObject cms, CmsResource resource) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_resource = resource;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsDetailPageFilter(CmsObject cms, String rootPath) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_path = rootPath;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Stream<CmsDetailPageInfo> filterDetailPages(List<CmsDetailPageInfo> infos) {
        ArrayList<CmsDetailPageInfo> infos2 = new ArrayList<CmsDetailPageInfo>(infos);
        Collections.sort(infos2, new Comparator<CmsDetailPageInfo>(){

            @Override
            public int compare(CmsDetailPageInfo a, CmsDetailPageInfo b) {
                return Integer.compare(this.getSortKey(a), this.getSortKey(b));
            }

            private int getSortKey(CmsDetailPageInfo info) {
                boolean qualifierFlag;
                boolean defaultDetailFlag = info.getType().equals("##DEFAULT##");
                boolean bl = qualifierFlag = info.getQualifier() != null;
                if (!defaultDetailFlag) {
                    if (qualifierFlag) {
                        return 0;
                    }
                    return 1;
                }
                if (qualifierFlag) {
                    return 2;
                }
                return 3;
            }
        });
        if (!infos2.stream().anyMatch(detailPage -> detailPage.getQualifier() == null)) {
            if (infos2.size() != 0 && LOG.isWarnEnabled()) {
                LOG.warn((Object)("No unqualified detail page entries found in list - probably a configuration error: " + String.valueOf(infos2)));
            }
            return Collections.emptyList().stream();
        }
        return infos2.stream().filter(info -> info.getQualifier() == null || this.checkQualifier((CmsDetailPageInfo)info));
    }

    protected boolean checkQualifier(CmsDetailPageInfo info) {
        String qualifier = info.getQualifier();
        if (qualifier == null) {
            return true;
        }
        if ((qualifier = qualifier.trim()).startsWith(PREFIX_CATEGORY)) {
            String categoryStr = qualifier.substring(PREFIX_CATEGORY.length());
            CmsPath categoryPath = new CmsPath(categoryStr);
            return this.getCategories().contains(categoryPath);
        }
        if (qualifier.equals(QUALIFIER_FOLDERS)) {
            CmsCategoryService catService = CmsCategoryService.getInstance();
            HashSet<CmsPath> categoryPaths = new HashSet<CmsPath>();
            HashSet<CmsPath> folderPaths = new HashSet<CmsPath>();
            try {
                if (this.m_resource == null && this.m_path != null) {
                    this.m_resource = this.m_cms.readResource(this.m_path, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                for (CmsUUID id : info.getFolders()) {
                    try {
                        CmsResource folder = this.m_cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
                        if (CmsStringUtil.isPrefixPath("/system/categories/", folder.getRootPath()) || folder.getRootPath().contains(this.getCategoryBase())) {
                            CmsCategory category = catService.getCategory(this.m_cms, folder);
                            categoryPaths.add(new CmsPath(category.getPath()));
                            continue;
                        }
                        folderPaths.add(new CmsPath(folder.getRootPath()));
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage());
                    }
                }
                CmsPath path = new CmsPath(this.m_resource.getRootPath());
                boolean result = true;
                LOG.debug((Object)("Checking detail page for " + this.m_resource.getRootPath() + ":" + String.valueOf(info)));
                if (!categoryPaths.isEmpty()) {
                    LOG.debug((Object)("Categories to check: " + String.valueOf(categoryPaths)));
                    LOG.debug((Object)("Content categories: " + String.valueOf(this.getCategories())));
                    CmsPath matchingCategory = categoryPaths.stream().filter(catPath -> this.getCategories().contains(catPath)).findFirst().orElse(null);
                    LOG.debug((Object)("Matching category: " + String.valueOf(matchingCategory)));
                    result &= matchingCategory != null;
                }
                if (!folderPaths.isEmpty()) {
                    LOG.debug((Object)("Folders to check: " + String.valueOf(folderPaths)));
                    CmsPath matchingFolder = folderPaths.stream().filter(folderPath -> folderPath.isPrefixOf(path)).findFirst().orElse(null);
                    LOG.debug((Object)("Matching folder: " + String.valueOf(matchingFolder)));
                    result &= matchingFolder != null;
                }
                LOG.debug((Object)("Check result: " + result));
                return result;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        LOG.error((Object)("Invalid detail page qualifier: " + qualifier));
        return false;
    }

    protected Set<CmsPath> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = this.readCategories();
        }
        return this.m_categories;
    }

    protected Set<CmsPath> readCategories() {
        try {
            List<CmsCategory> categories;
            if (this.m_resource != null) {
                categories = CmsCategoryService.getInstance().readResourceCategories(this.m_cms, this.m_resource);
            } else {
                CmsResource resource = this.m_cms.readResource(this.m_path, CmsResourceFilter.IGNORE_EXPIRATION);
                categories = CmsCategoryService.getInstance().readResourceCategories(this.m_cms, resource);
            }
            HashSet<CmsPath> result = new HashSet<CmsPath>();
            for (CmsCategory category : categories) {
                result.add(new CmsPath(category.getPath()));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private String getCategoryBase() {
        if (this.m_categoryBase == null) {
            this.m_categoryBase = CmsCategoryService.getInstance().getRepositoryBaseFolderName(this.m_cms);
        }
        return this.m_categoryBase;
    }
}

