/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.opencms.ade.contenteditor.A_CmsXmlContentEditorChangeHandler;
import org.opencms.file.CmsObject;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDelayedDefaultChangeHandler
extends A_CmsXmlContentEditorChangeHandler {
    private String m_relPath;
    private String m_default;

    @Override
    public CmsXmlContent handleChange(CmsObject cms, CmsXmlContent content, Locale locale, Collection<String> changedPaths) {
        ArrayList<String> paths = new ArrayList<String>(changedPaths);
        for (String changedPath : paths) {
            String fieldPath = this.resolveRelativePath(changedPath, this.m_relPath);
            I_CmsXmlContentValue value = content.getValue(fieldPath, locale);
            if (value == null || !CmsStringUtil.isEmptyOrWhitespaceOnly(value.getStringValue(cms))) continue;
            CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(cms, content, locale);
            String newVal = resolver.resolveMacros(this.m_default);
            value.setStringValue(cms, newVal);
        }
        return content;
    }

    @Override
    public void setConfiguration(String configuration) {
        super.setConfiguration(configuration);
        int pipePos = configuration.indexOf("|");
        if (pipePos < 0 || pipePos == configuration.length() - 1) {
            throw new RuntimeException("Invalid configuration for " + this.getClass().getName());
        }
        this.m_relPath = configuration.substring(0, pipePos);
        this.m_default = configuration.substring(pipePos + 1, configuration.length());
    }
}

