/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Map;
import java.util.Set;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsFormatterConfig
implements IsSerializable {
    public static final String FORMATTER_SETTINGS_KEY = "formatterSettings#";
    public static final String SCHEMA_FORMATTER_ID = "schema_formatter";
    private Set<String> m_cssResources;
    private String m_id;
    private String m_inlineCss;
    private String m_jspRootPath;
    private String m_label;
    private Map<String, String> m_nestedFormatterPrefixes;
    private Map<String, CmsXmlContentProperty> m_settingConfig;
    private String m_description;
    private String m_key;

    public CmsFormatterConfig(String id) {
        this.m_id = id;
    }

    protected CmsFormatterConfig() {
    }

    public static String getSettingsKeyForContainer(String containerName) {
        return FORMATTER_SETTINGS_KEY + containerName;
    }

    public Set<String> getCssResources() {
        return this.m_cssResources;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getId() {
        return this.m_id;
    }

    public String getInlineCss() {
        return this.m_inlineCss;
    }

    public String getJspRootPath() {
        return this.m_jspRootPath;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getKeyOrId() {
        if (this.m_key != null) {
            return this.m_key;
        }
        return this.getId();
    }

    public String getLabel() {
        return this.m_label;
    }

    public Map<String, String> getNestedFormatterPrefixes() {
        return this.m_nestedFormatterPrefixes;
    }

    public Map<String, CmsXmlContentProperty> getSettingConfig() {
        return this.m_settingConfig;
    }

    public boolean hasInlineCss() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_inlineCss);
    }

    public void setCssResources(Set<String> cssResources) {
        this.m_cssResources = cssResources;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setInlineCss(String inlineCss) {
        this.m_inlineCss = inlineCss;
    }

    public void setJspRootPath(String jspRootPath) {
        this.m_jspRootPath = jspRootPath;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public void setNestedFormatterPrefixes(Map<String, String> nestedFormatterPrefixes) {
        this.m_nestedFormatterPrefixes = nestedFormatterPrefixes;
    }

    public void setSettingConfig(Map<String, CmsXmlContentProperty> settingConfig) {
        this.m_settingConfig = settingConfig;
    }
}

