/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.shared;

import com.google.common.collect.Sets;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.containerpage.shared.CmsContainerElement;

public class CmsContainer
implements IsSerializable {
    private boolean m_detailOnly;
    private boolean m_detailView;
    private boolean m_editable;
    private List<CmsContainerElement> m_elements;
    private String m_emptyContainerContent;
    private boolean m_isDetailViewContainer;
    private boolean m_isRootContainer;
    private int m_maxElements;
    private String m_name;
    private String m_parentContainerName;
    private String m_parentInstanceId;
    private Map<String, String> m_settingPresets = new HashMap<String, String>();
    private String m_type;
    private int m_width;

    public CmsContainer(String name, String type, String emptyContainerContent, int width, int maxElements, boolean isDetailViewContainer, boolean detailView, boolean editable, List<CmsContainerElement> elements, String parentContainerName, String parentInstanceId, Map<String, String> settingPresets) {
        this.m_elements = elements;
        this.m_name = name;
        this.m_type = type;
        this.m_emptyContainerContent = emptyContainerContent;
        this.m_maxElements = maxElements;
        this.m_width = width;
        this.m_isDetailViewContainer = isDetailViewContainer;
        this.m_detailView = detailView;
        this.m_editable = editable;
        this.m_parentContainerName = parentContainerName;
        this.m_parentInstanceId = parentInstanceId;
        this.m_settingPresets = settingPresets != null ? settingPresets : new HashMap();
    }

    protected CmsContainer() {
    }

    public static Set<String> splitType(String containerTypeSpec) {
        return Sets.newHashSet(Arrays.asList(containerTypeSpec.trim().split(" *, *")));
    }

    public List<CmsContainerElement> getElements() {
        return this.m_elements;
    }

    public String getEmptyContainerContent() {
        return this.m_emptyContainerContent;
    }

    public int getMaxElements() {
        return this.m_maxElements;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParentContainerName() {
        return this.m_parentContainerName;
    }

    public String getParentInstanceId() {
        return this.m_parentInstanceId;
    }

    public Map<String, String> getSettingPresets() {
        return this.m_settingPresets;
    }

    public String getType() {
        return this.m_type;
    }

    public int getWidth() {
        return this.m_width;
    }

    public boolean isDetailOnly() {
        return this.m_detailOnly;
    }

    public boolean isDetailView() {
        return this.m_detailView;
    }

    public boolean isDetailViewContainer() {
        return this.m_isDetailViewContainer;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public boolean isRootContainer() {
        return this.m_isRootContainer;
    }

    public boolean isSubContainer() {
        return this.m_parentContainerName != null;
    }

    public void setDetailOnly(boolean detailOnly) {
        this.m_detailOnly = detailOnly;
    }

    public void setElements(List<CmsContainerElement> elements) {
        this.m_elements = elements;
    }

    public void setMaxElements(int maxElements) {
        this.m_maxElements = maxElements;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRootContainer(boolean isRootContainer) {
        this.m_isRootContainer = isRootContainer;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String toString() {
        return "[Container name='" + this.m_name + "' type='" + this.m_type + "' numElements='" + (this.m_elements == null ? 0 : this.m_elements.size()) + "']";
    }
}

