/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsTypeAnalyzer {
    private static final Log LOG = CmsLog.getLog(CmsTypeAnalyzer.class);
    public static final CmsUUID UNKNOWN_FORMATTER = CmsUUID.getNullUUID();
    private State m_state = new State();
    private Locale m_locale;
    private CmsObject m_cms;
    private Pattern m_templatePattern;

    public CmsTypeAnalyzer(CmsObject cms, String siteRoot, String path, boolean skipDetailOnly, Set<String> excludedContainers, String templateRegex) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_cms.getRequestContext().setSiteRoot(siteRoot);
        this.m_state.m_path = path;
        this.m_state.m_siteRoot = siteRoot;
        this.m_state.m_skipDetailOnly = skipDetailOnly;
        this.m_state.m_excludedContainers = excludedContainers;
        this.m_state.m_templateRegex = templateRegex;
        this.m_templatePattern = Pattern.compile(templateRegex);
        this.m_locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
    }

    public static State readState(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try (ObjectInputStream stream = new ObjectInputStream(new InflaterInputStream(bais));){
            State state = (State)stream.readObject();
            return state;
        }
    }

    public static State run(CmsObject cms, String path, boolean skipDetailOnly, String excludeContainersStr, String templateRegex) throws CmsException {
        HashSet<String> excludedContainers = new HashSet<String>();
        for (String token : excludeContainersStr.split(",")) {
            if ("".equals(token = token.trim())) continue;
            excludedContainers.add(token);
        }
        return new CmsTypeAnalyzer(cms, cms.getRequestContext().getSiteRoot(), path, skipDetailOnly, excludedContainers, templateRegex).processFolder();
    }

    public static byte[] writeState(State state) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(new DeflaterOutputStream(baos));){
            out.writeObject(state);
        }
        return baos.toByteArray();
    }

    public State getState() {
        return this.m_state;
    }

    public State processFolder() throws CmsException {
        long start = System.currentTimeMillis();
        I_CmsResourceType pageType = OpenCms.getResourceManager().getResourceType("containerpage");
        I_CmsResourceType modelGroupType = OpenCms.getResourceManager().getResourceType("modelgroup");
        List<CmsResource> pages = this.m_cms.readResources(this.m_state.m_path, CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(pageType));
        for (CmsResource cmsResource : pages) {
            if (!this.checkTemplate(cmsResource) || this.m_state.m_skipDetailOnly && cmsResource.getRootPath().contains(".detailContainers")) continue;
            this.processPage(cmsResource);
        }
        List<CmsResource> modelGroups = this.m_cms.readResources(this.m_state.m_path, CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(modelGroupType));
        for (CmsResource cmsResource : modelGroups) {
            if (!this.checkTemplate(cmsResource)) continue;
            this.processPage(cmsResource);
        }
        List<CmsResource> list = this.m_cms.readResources(this.m_state.m_path, CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(OpenCms.getResourceManager().getResourceType("groupcontainer")));
        for (CmsResource elementGroup : list) {
            if (!this.checkTemplate(elementGroup)) continue;
            this.processElementGroup(elementGroup);
        }
        for (String type2 : OpenCms.getADEManager().getContentTypeNames(false)) {
            this.addTypeInfo(type2);
        }
        long l = System.currentTimeMillis();
        for (String type3 : this.m_state.m_types.keySet()) {
            Multimap<CmsUUID, CmsUUID> usage = this.m_state.m_typeUsage.get(type3);
            if (usage == null) continue;
            this.m_state.m_types.get(type3).setUsageCount(usage.values().size());
        }
        LinkedHashMap<String, TypeBean> typesSorted = new LinkedHashMap<String, TypeBean>();
        this.m_state.m_types.values().stream().sorted((a, b) -> Integer.compare(b.getUsageCount(), a.getUsageCount())).forEach(type -> typesSorted.put(type.getName(), (TypeBean)type));
        this.m_state.m_types = typesSorted;
        LOG.info((Object)("Processed " + pages.size() + " pages, took " + (l - start) + "ms"));
        return this.m_state;
    }

    private void addEntry(String typeName, CmsUUID pageId, CmsUUID formatterId) {
        this.m_state.m_typeUsage.computeIfAbsent(typeName, k -> ArrayListMultimap.create()).put((Object)formatterId, (Object)pageId);
    }

    private void addResource(CmsResource pageResource) {
        this.m_state.m_pages.put(pageResource.getStructureId(), new ResourceBean(pageResource.getStructureId(), this.m_cms.getSitePath(pageResource)));
    }

    private void addTypeInfo(String type) {
        if (this.m_state.m_types.get(type) != null) {
            return;
        }
        int count = -1;
        try {
            List<CmsResource> resources = this.m_cms.readResources(this.m_state.m_path, CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(OpenCms.getResourceManager().getResourceType(type)), true);
            count = resources.size();
            String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type).getKey();
            String label = OpenCms.getWorkplaceManager().getMessages(this.m_locale).key(key);
            this.m_state.m_types.put(type, new TypeBean(type, label, count));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void checkFunction(CmsResource pageResource, CmsContainerElementBean element) {
        if (OpenCms.getResourceManager().matchResourceType("function", element.getResource().getTypeId())) {
            this.m_state.m_functionUsage.computeIfAbsent(element.getResource().getRootPath(), p -> new HashSet()).add(this.m_cms.getSitePath(pageResource));
        }
    }

    private boolean checkTemplate(CmsResource page) {
        try {
            CmsProperty templateProp = this.m_cms.readPropertyObject(page, "template", true);
            String templateValue = templateProp.getValue();
            if (templateValue == null) {
                templateValue = "";
            }
            return this.m_templatePattern.matcher(templateValue).matches();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private void processElementGroup(CmsResource groupResource) throws CmsException {
        this.addResource(groupResource);
        CmsXmlGroupContainer groupXml = CmsXmlGroupContainerFactory.unmarshal(this.m_cms, this.m_cms.readFile(groupResource));
        CmsGroupContainerBean group = groupXml.getGroupContainer(this.m_cms);
        for (CmsContainerElementBean element : group.getElements()) {
            try {
                element.initResource(this.m_cms);
                this.checkFunction(groupResource, element);
                this.addEntry(element.getTypeName(), groupResource.getStructureId(), UNKNOWN_FORMATTER);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void processPage(CmsResource pageResource) throws CmsException {
        LOG.debug((Object)("processing page " + pageResource.getRootPath()));
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, pageResource.getRootPath());
        this.addResource(pageResource);
        CmsXmlContainerPage pageXml = CmsXmlContainerPageFactory.unmarshal(this.m_cms, this.m_cms.readFile(pageResource));
        CmsContainerPageBean page = pageXml.getContainerPage(this.m_cms);
        for (CmsContainerBean container : page.getContainers().values()) {
            if (this.m_state.m_excludedContainers.contains(container.getName())) continue;
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(this.m_cms);
                    this.checkFunction(pageResource, element);
                    Map<String, String> settings = element.getIndividualSettings();
                    String formatterRef = settings.get("formatterSettings#" + container.getName());
                    if (formatterRef == null) {
                        for (String key : settings.keySet()) {
                            if (!key.startsWith("formatterSettings#")) continue;
                            formatterRef = settings.get(key);
                        }
                    }
                    I_CmsFormatterBean formatter = config.findFormatter(formatterRef, true);
                    CmsUUID formatterId = UNKNOWN_FORMATTER;
                    if (formatter != null) {
                        formatterId = new CmsUUID(formatter.getId());
                        FormatterBean bean = new FormatterBean(formatterId, formatter.getLocation(), formatter.getKey(), formatter.getNiceName(this.m_locale));
                        this.m_state.m_formatters.putIfAbsent(formatterId, bean);
                    } else {
                        this.m_state.m_formatters.putIfAbsent(formatterId, new FormatterBean(UNKNOWN_FORMATTER, "unknown", null, "Unknown formatter"));
                    }
                    this.addEntry(element.getTypeName(), pageResource.getStructureId(), formatterId);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Map<String, Multimap<CmsUUID, CmsUUID>> m_typeUsage = new HashMap<String, Multimap<CmsUUID, CmsUUID>>();
        protected Map<CmsUUID, FormatterBean> m_formatters = new HashMap<CmsUUID, FormatterBean>();
        protected Map<CmsUUID, ResourceBean> m_pages = new HashMap<CmsUUID, ResourceBean>();
        protected Map<String, TypeBean> m_types = new LinkedHashMap<String, TypeBean>();
        protected String m_path;
        protected String m_siteRoot;
        protected Set<String> m_excludedContainers;
        public boolean m_skipDetailOnly;
        private Map<String, Set<String>> m_functionUsage = new HashMap<String, Set<String>>();
        public String m_templateRegex;

        public static long getSerialversionuid() {
            return 1L;
        }

        public Set<String> getExcludedContainers() {
            return this.m_excludedContainers;
        }

        public Map<CmsUUID, FormatterBean> getFormatters() {
            return this.m_formatters;
        }

        public Map<String, Set<String>> getFunctionUsages() {
            return this.m_functionUsage;
        }

        public Map<CmsUUID, ResourceBean> getPages() {
            return this.m_pages;
        }

        public List<String> getPages(String type, CmsUUID formatter) {
            Collection usage = this.getTypeUsage().get(type).get((Object)formatter);
            return usage.stream().map(id -> this.m_pages.get(id).getPath()).distinct().sorted().collect(Collectors.toList());
        }

        public String getPath() {
            return this.m_path;
        }

        public String getSiteRoot() {
            return this.m_siteRoot;
        }

        public List<FormatterBean> getSortedFormatters(String type) {
            if (!this.m_typeUsage.containsKey(type)) {
                return Collections.emptyList();
            }
            Multimap<CmsUUID, CmsUUID> formatterUsages = this.m_typeUsage.get(type);
            return formatterUsages.keySet().stream().sorted((f1, f2) -> -Integer.compare(formatterUsages.get(f1).size(), formatterUsages.get(f2).size())).map(id -> this.m_formatters.get(id)).collect(Collectors.toList());
        }

        public String getTemplateRegex() {
            return this.m_templateRegex;
        }

        public Map<String, TypeBean> getTypes() {
            return this.m_types;
        }

        public Map<String, Multimap<CmsUUID, CmsUUID>> getTypeUsage() {
            return this.m_typeUsage;
        }

        public boolean isSkipDetailOnly() {
            return this.m_skipDetailOnly;
        }
    }

    public static class TypeBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_name;
        private String m_niceName;
        private int m_count;
        private int m_usageCount;

        public TypeBean(String name, String niceName, int count) {
            this.m_name = name;
            this.m_niceName = niceName;
            this.m_count = count;
        }

        public int getCount() {
            return this.m_count;
        }

        public String getName() {
            return this.m_name;
        }

        public String getNiceName() {
            return this.m_niceName;
        }

        public int getUsageCount() {
            return this.m_usageCount;
        }

        public void setCount(int count) {
            this.m_count = count;
        }

        public void setUsageCount(int referenceCount) {
            this.m_usageCount = referenceCount;
        }
    }

    public static class ResourceBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CmsUUID m_id;
        private String m_path;

        public ResourceBean(CmsUUID id, String path) {
            this.m_id = id;
            this.m_path = path;
        }

        public CmsUUID getId() {
            return this.m_id;
        }

        public String getPath() {
            return this.m_path;
        }
    }

    public static class FormatterBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CmsUUID m_id;
        private String m_key;
        private String m_path;
        private String m_niceName;

        public FormatterBean(CmsUUID id, String path, String key, String niceName) {
            this.m_id = id;
            this.m_path = path;
            this.m_key = key;
            this.m_niceName = niceName;
        }

        public CmsUUID getId() {
            return this.m_id;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getNiceName() {
            return this.m_niceName;
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

