/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.plugins;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.plugins.CmsSitePlugin;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLinkInfo;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsTemplatePluginFinder {
    private static final Log LOG = CmsLog.getLog(CmsTemplatePluginFinder.class);
    private CmsJspStandardContextBean m_standardContextBean;

    public CmsTemplatePluginFinder(CmsJspStandardContextBean standardContextBean) {
        this.m_standardContextBean = standardContextBean;
    }

    public static Multimap<String, CmsTemplatePlugin> getActiveTemplatePluginsFromSitePlugins(CmsADEConfigData config) {
        ArrayList<CmsTemplatePlugin> plugins = new ArrayList<CmsTemplatePlugin>();
        for (CmsSitePlugin sitePlugin : config.getSitePlugins()) {
            plugins.addAll(sitePlugin.getPlugins());
        }
        return CmsTemplatePluginFinder.getActivePlugins(plugins);
    }

    private static List<CmsTemplatePlugin> collectPluginsForCurrentPage(CmsJspStandardContextBean standardContext) throws CmsException {
        ArrayList<CmsTemplatePlugin> plugins = new ArrayList<CmsTemplatePlugin>();
        CmsObject cms = standardContext.getVfs().getCmsObject();
        HttpServletRequest req = (HttpServletRequest)standardContext.getRequest();
        standardContext.initPage();
        CmsContainerPageBean containerPage = standardContext.getPage();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().getRootUri());
        if (containerPage != null && containerPage.getElements() != null) {
            Object detailOnly;
            ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>(containerPage.getContainers().values());
            if (standardContext.isDetailRequest() && (detailOnly = CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, (ServletRequest)req, cms.getRequestContext().getRootUri())) != null) {
                containers.addAll(((CmsContainerPageBean)detailOnly).getContainers().values());
            }
            for (CmsContainerBean container : containers) {
                for (CmsContainerElementBean element : container.getElements()) {
                    try {
                        element.initResource(cms);
                        if (standardContext.getIsOnlineProject() && !element.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                        if (element.isGroupContainer(cms) || element.isInheritedContainer(cms)) {
                            List<CmsContainerElementBean> subElements = element.isGroupContainer(cms) ? CmsJspTagContainer.getGroupContainerElements(cms, element, (ServletRequest)req, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(cms, element);
                            for (CmsContainerElementBean subElement : subElements) {
                                I_CmsFormatterBean formatter;
                                subElement.initResource(cms);
                                if (standardContext.getIsOnlineProject() && !subElement.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime()) || (formatter = CmsTemplatePluginFinder.getFormatterBeanForElement(cms, config, subElement, container)) == null) continue;
                                plugins.addAll(formatter.getTemplatePlugins());
                            }
                            continue;
                        }
                        I_CmsFormatterBean formatter = CmsTemplatePluginFinder.getFormatterBeanForElement(cms, config, element, container);
                        if (formatter == null) continue;
                        plugins.addAll(formatter.getTemplatePlugins());
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                    }
                }
            }
        }
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId(), CmsResourceFilter.ignoreExpirationOffline(cms));
                CmsFormatterConfiguration detailContentFormatters = config.getFormatters(cms, detailContent);
                for (I_CmsFormatterBean formatter : detailContentFormatters.getDetailFormatters()) {
                    plugins.addAll(formatter.getTemplatePlugins());
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (CmsSitePlugin sitePlugin : config.getSitePlugins()) {
            plugins.addAll(sitePlugin.getPlugins());
        }
        return plugins;
    }

    private static Multimap<String, CmsTemplatePlugin> getActivePlugins(List<CmsTemplatePlugin> plugins) {
        ArrayListMultimap pluginsByGroup = ArrayListMultimap.create();
        for (CmsTemplatePlugin plugin : plugins) {
            pluginsByGroup.put((Object)plugin.getGroup(), (Object)plugin);
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        for (String group : pluginsByGroup.keySet()) {
            List<CmsTemplatePlugin> active = CmsTemplatePluginFinder.sortAndDeduplicatePlugins((List)pluginsByGroup.get((Object)group));
            result.putAll((Object)group, active);
        }
        return result;
    }

    private static I_CmsFormatterBean getFormatterBeanForElement(CmsObject cms, CmsADEConfigData config, CmsContainerElementBean element, CmsContainerBean container) {
        int containerWidth = -1;
        if (container.getWidth() == null) {
            containerWidth = -2;
        } else {
            try {
                containerWidth = Integer.parseInt(container.getWidth());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        I_CmsFormatterBean result = CmsJspTagContainer.getFormatterConfigurationForElement(cms, element, config, container.getName(), container.getType(), containerWidth);
        return result;
    }

    private static List<CmsTemplatePlugin> sortAndDeduplicatePlugins(List<CmsTemplatePlugin> plugins) {
        ArrayList<CmsTemplatePlugin> result = new ArrayList<CmsTemplatePlugin>();
        HashSet<CmsLinkInfo> seenTargets = new HashSet<CmsLinkInfo>();
        Collections.sort(plugins, (p1, p2) -> Integer.compare(p2.getOrder(), p1.getOrder()));
        for (CmsTemplatePlugin plugin : plugins) {
            try {
                CmsLinkInfo target = plugin.getTarget();
                if (seenTargets.contains(target)) continue;
                seenTargets.add(target);
                result.add(plugin);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Multimap<String, CmsTemplatePlugin> getTemplatePlugins() {
        try {
            return CmsTemplatePluginFinder.getActivePlugins(CmsTemplatePluginFinder.collectPluginsForCurrentPage(this.m_standardContextBean));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return ArrayListMultimap.create();
        }
    }
}

