/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentRootLocation;

public class CmsSitePlugin {
    public static final String N_DESCRIPTION = "Description";
    public static final String N_NICE_NAME = "NiceName";
    public static final String N_PLUGIN = "Plugin";
    private String m_niceName;
    private String m_description;
    private String m_origin;
    private List<CmsTemplatePlugin> m_plugins;
    private CmsUUID m_id;

    public CmsSitePlugin(CmsUUID id, String niceName, String description, List<CmsTemplatePlugin> plugins, String origin) {
        this.m_id = id;
        this.m_plugins = Collections.unmodifiableList(new ArrayList<CmsTemplatePlugin>(plugins));
        this.m_niceName = niceName;
        this.m_description = description;
        this.m_origin = origin;
    }

    public static CmsSitePlugin read(CmsObject cms, CmsResource res) throws CmsException {
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(res));
        return CmsSitePlugin.readSitePlugin(cms, content);
    }

    public static CmsSitePlugin readSitePlugin(CmsObject cms, CmsXmlContent content) {
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, Locale.ENGLISH);
        String niceName = root.getSubValue(N_NICE_NAME).getValue().getStringValue(cms).trim();
        String description = root.getSubValue(N_DESCRIPTION).getValue().getStringValue(cms).trim();
        List<CmsTemplatePlugin> plugins = CmsTemplatePlugin.parsePlugins(cms, root, N_PLUGIN);
        CmsSitePlugin result = new CmsSitePlugin(content.getFile().getStructureId(), niceName, description, plugins, content.getFile().getRootPath());
        return result;
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getNiceName() {
        return this.m_niceName;
    }

    public String getOrigin() {
        return this.m_origin;
    }

    public List<CmsTemplatePlugin> getPlugins() {
        return this.m_plugins;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

