/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsFormatterConfigurationCacheState {
    private static final Log LOG = CmsLog.getLog(CmsFormatterConfigurationCacheState.class);
    private Map<CmsUUID, I_CmsFormatterBean> m_autoEnabledFormatters;
    private Map<CmsUUID, I_CmsFormatterBean> m_formatters = new HashMap<CmsUUID, I_CmsFormatterBean>();
    private Multimap<String, I_CmsFormatterBean> m_formattersByType;

    public CmsFormatterConfigurationCacheState(Map<CmsUUID, I_CmsFormatterBean> formatters) {
        this.m_formatters = new HashMap<CmsUUID, I_CmsFormatterBean>(formatters);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created new formatter configuration: ");
            LOG.debug((Object)this.m_formatters.toString());
        }
    }

    public CmsFormatterConfigurationCacheState createUpdatedCopy(Map<CmsUUID, I_CmsFormatterBean> updateFormatters) {
        HashMap newFormatters = Maps.newHashMap(this.getFormatters());
        for (Map.Entry<CmsUUID, I_CmsFormatterBean> entry : updateFormatters.entrySet()) {
            CmsUUID key = entry.getKey();
            I_CmsFormatterBean value = entry.getValue();
            if (value != null) {
                newFormatters.put(key, value);
                continue;
            }
            newFormatters.remove(key);
        }
        return new CmsFormatterConfigurationCacheState(newFormatters);
    }

    public Map<CmsUUID, I_CmsFormatterBean> getAutoEnabledFormatters() {
        if (this.m_autoEnabledFormatters == null) {
            HashMap result = Maps.newHashMap();
            for (Map.Entry<CmsUUID, I_CmsFormatterBean> entry : this.m_formatters.entrySet()) {
                if (!entry.getValue().isAutoEnabled()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            this.m_autoEnabledFormatters = result;
        }
        return Collections.unmodifiableMap(this.m_autoEnabledFormatters);
    }

    public Map<CmsUUID, I_CmsFormatterBean> getFormatters() {
        return Collections.unmodifiableMap(this.m_formatters);
    }

    public Collection<I_CmsFormatterBean> getFormattersForType(String resourceType, boolean filterAutoEnabled) {
        Collection result = this.getFormattersByType().get((Object)resourceType);
        if (filterAutoEnabled) {
            result = result.stream().filter(formatter -> formatter.isAutoEnabled()).collect(Collectors.toList());
        }
        return result;
    }

    private Multimap<String, I_CmsFormatterBean> getFormattersByType() {
        if (this.m_formattersByType == null) {
            ArrayListMultimap formattersByType = ArrayListMultimap.create();
            for (I_CmsFormatterBean formatter : this.m_formatters.values()) {
                for (String typeName : formatter.getResourceTypeNames()) {
                    formattersByType.put((Object)typeName, (Object)formatter);
                }
            }
            this.m_formattersByType = formattersByType;
        }
        Multimap result = Multimaps.unmodifiableMultimap(this.m_formattersByType);
        return result;
    }
}

