/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

public class CmsSitemapAttributeEditorConfiguration {
    public static final CmsSitemapAttributeEditorConfiguration EMPTY = new CmsSitemapAttributeEditorConfiguration(new HashMap<String, CmsXmlContentProperty>());
    private Map<String, CmsXmlContentProperty> m_attributeDefinitions;

    public CmsSitemapAttributeEditorConfiguration(Map<String, CmsXmlContentProperty> attributeDefinitions) {
        this.m_attributeDefinitions = Collections.unmodifiableMap(new LinkedHashMap<String, CmsXmlContentProperty>(attributeDefinitions));
    }

    public static CmsSitemapAttributeEditorConfiguration read(CmsObject cms, CmsResource res) throws CmsException {
        LinkedHashMap<String, CmsXmlContentProperty> resultMap = new LinkedHashMap<String, CmsXmlContentProperty>();
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(res));
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, Locale.ENGLISH);
        for (I_CmsXmlContentValueLocation loc : root.getSubValues("Setting")) {
            CmsXmlContentProperty propDef = CmsConfigurationReader.parseProperty(cms, loc).getPropertyData();
            resultMap.put(propDef.getName(), propDef);
        }
        return new CmsSitemapAttributeEditorConfiguration(resultMap);
    }

    public Map<String, CmsXmlContentProperty> getAttributeDefinitions() {
        return this.m_attributeDefinitions;
    }
}

