/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigCacheState;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationCache;
import org.opencms.ade.configuration.CmsDetailNameCache;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsGlobalConfigurationCacheEventHandler;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.I_CmsSitemapExtraInfoProvider;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCache;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.ade.configuration.plugins.CmsTemplatePluginFinder;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationCache;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationWriter;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.detailpage.CmsDetailPageConfigurationWriter;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.I_CmsDetailPageHandler;
import org.opencms.ade.upload.CmsUploadWarningTable;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.jsp.CmsJspTagLink;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.CmsTemplatePluginWrapper;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsADECache;
import org.opencms.xml.containerpage.CmsADECacheSettings;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsADEManager {
    public static final String CLIENT_ID_SEPERATOR = "#";
    public static final String CONFIG_FILE_NAME = ".config";
    public static final String CONFIG_FOLDER_TYPE = "content_folder";
    public static final String CONFIG_SUFFIX = "/.content/.config";
    public static final String CONFIG_TYPE = "sitemap_config";
    public static final String CONTENT_FOLDER_NAME = ".content";
    public static final String DEFAULT_DETAILPAGE_TYPE = "##DEFAULT##";
    public static final int DEFAULT_ELEMENT_LIST_SIZE = 10;
    public static final String ELEMENT_VIEW_TYPE = "elementview";
    public static final String MODULE_CONFIG_TYPE = "module_config";
    public static final String MODULE_NAME_ADE_CONFIG = "org.opencms.base";
    public static final String N_LINK = "Link";
    public static final String N_TYPE = "Type";
    public static final String PATH_SITEMAP_EDITOR_JSP = "/system/workplace/commons/sitemap.jsp";
    protected static final String ADDINFO_ADE_FAVORITE_LIST = "ADE_FAVORITE_LIST";
    protected static final String ADDINFO_ADE_RECENT_LIST = "ADE_RECENT_LIST";
    protected static final String ADDINFO_ADE_SHOW_EDITOR_HELP = "ADE_SHOW_EDITOR_HELP";
    private static final Log LOG = CmsLog.getLog(CmsADEManager.class);
    private CmsADECache m_cache;
    private I_CmsResourceType m_configType;
    private I_CmsDetailPageHandler m_detailPageHandler;
    private I_CmsResourceType m_elementViewType;
    private Status m_initStatus = Status.notInitialized;
    private I_CmsResourceType m_moduleConfigType;
    private CmsConfigurationCache m_offlineCache;
    private CmsObject m_offlineCms;
    private CmsContainerConfigurationCache m_offlineContainerConfigurationCache;
    private CmsDetailNameCache m_offlineDetailIdCache;
    private CmsFormatterConfigurationCache m_offlineFormatterCache;
    private CmsConfigurationCache m_onlineCache;
    private CmsObject m_onlineCms;
    private CmsContainerConfigurationCache m_onlineContainerConfigurationCache;
    private CmsDetailNameCache m_onlineDetailIdCache;
    private CmsFormatterConfigurationCache m_onlineFormatterCache;
    private Map<String, String> m_parameters;
    private CmsUploadWarningTable m_uploadWarningTable = new CmsUploadWarningTable();
    private List<I_CmsSitemapExtraInfoProvider> m_sitemapExtraInfoProviders = new ArrayList<I_CmsSitemapExtraInfoProvider>();

    public CmsADEManager(CmsObject adminCms, CmsMemoryMonitor memoryMonitor, CmsSystemConfiguration systemConfiguration) {
        CmsADECacheSettings cacheSettings = systemConfiguration.getAdeCacheSettings();
        if (cacheSettings == null) {
            cacheSettings = new CmsADECacheSettings();
        }
        this.m_onlineCms = adminCms;
        this.m_cache = new CmsADECache(memoryMonitor, cacheSettings);
        this.m_parameters = new LinkedHashMap<String, String>(systemConfiguration.getAdeParameters());
        this.m_detailPageHandler = systemConfiguration.getDetailPageHandler();
    }

    public CmsWaitHandle addFormatterCacheWaitHandle(boolean online) {
        CmsWaitHandle handle = new CmsWaitHandle(true);
        CmsFormatterConfigurationCache cache = online ? this.m_onlineFormatterCache : this.m_offlineFormatterCache;
        cache.addWaitHandle(handle);
        return handle;
    }

    public void addSitemapExtraInfoProvider(I_CmsSitemapExtraInfoProvider provider) {
        this.m_sitemapExtraInfoProviders.add(provider);
    }

    public boolean canEditSitemapConfiguration(CmsObject cms) {
        CmsRole role = this.getRoleForSitemapConfigEditing();
        if (role == null) {
            return true;
        }
        return OpenCms.getRoleManager().hasRole(cms, role);
    }

    public String findEntryPoint(CmsObject cms, String openPath) {
        CmsADEConfigData configData = this.lookupConfiguration(cms, openPath);
        String result = configData.getBasePath();
        if (result == null) {
            return cms.getRequestContext().addSiteRoot("/");
        }
        return result;
    }

    public void flushInheritanceGroupChanges() {
        this.m_offlineContainerConfigurationCache.flushUpdates();
        this.m_onlineContainerConfigurationCache.flushUpdates();
    }

    public List<CmsDetailPageInfo> getAllDetailPages(CmsObject cms) {
        return this.getCacheState(this.isOnline(cms)).getAllDetailPages();
    }

    public CmsADECache getCache() {
        return this.m_cache;
    }

    public CmsFormatterConfigurationCacheState getCachedFormatters(boolean online) {
        CmsFormatterConfigurationCache cache = online ? this.m_onlineFormatterCache : this.m_offlineFormatterCache;
        return cache.getState();
    }

    public CmsADEConfigCacheState getCacheState(boolean online) {
        return (online ? this.m_onlineCache : this.m_offlineCache).getState();
    }

    public I_CmsResourceType getConfigurationType() {
        return this.m_configType;
    }

    public Set<String> getConfiguredWorkplaceBundles() {
        CmsADEConfigData configData = this.internalLookupConfiguration(null, null);
        return configData.getConfiguredWorkplaceBundles();
    }

    public Set<String> getContentTypeNames(boolean online) {
        CmsConfigurationCache cache = online ? this.m_onlineCache : this.m_offlineCache;
        return cache.getState().getContentTypes();
    }

    public CmsContainerElementBean getCurrentElement(ServletRequest req) throws CmsException {
        CmsJspStandardContextBean sCBean = CmsJspStandardContextBean.getInstance(req);
        CmsJspStandardContextBean.CmsContainerElementWrapper element = sCBean.getElement();
        if (element == null) {
            throw new CmsException(Messages.get().container("ERR_READING_ELEMENT_FROM_REQUEST_1", sCBean.getRequestContext().getUri()));
        }
        return element;
    }

    public CmsDetailNameCache getDetailIdCache(boolean online) {
        return online ? this.m_onlineDetailIdCache : this.m_offlineDetailIdCache;
    }

    public List<CmsADEConfigData.DetailInfo> getDetailInfo(CmsObject cms) {
        return this.getCacheState(this.isOnline(cms)).getDetailInfosForSubsites(cms);
    }

    public String getDetailPage(CmsObject cms, String pageRootPath, String originPath) {
        return this.getDetailPage(cms, pageRootPath, originPath, null);
    }

    public String getDetailPage(CmsObject cms, String rootPath, String linkSource, String targetDetailPage) {
        return this.getDetailPageHandler().getDetailPage(cms, rootPath, linkSource, targetDetailPage);
    }

    public I_CmsDetailPageHandler getDetailPageHandler() {
        return this.m_detailPageHandler;
    }

    public List<String> getDetailPages(CmsObject cms, String type) {
        CmsConfigurationCache cache = this.isOnline(cms) ? this.m_onlineCache : this.m_offlineCache;
        return cache.getState().getDetailPages(type);
    }

    public Set<String> getDetailPageTypes(CmsObject cms) {
        return this.getCacheState(this.isOnline(cms)).getDetailPageTypes();
    }

    public Map<String, CmsXmlContentProperty> getElementSettings(CmsObject cms, CmsResource resource) throws CmsException {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
            Map<String, CmsXmlContentProperty> settings = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource).getSettings(cms, resource);
            result.putAll(settings);
            return CmsXmlContentPropertyHelper.copyPropertyConfiguration(result);
        }
        return Collections.emptyMap();
    }

    public Map<CmsUUID, CmsElementView> getElementViews(CmsObject cms) {
        CmsConfigurationCache cache = this.getCache(this.isOnline(cms));
        ArrayList viewList = Lists.newArrayList();
        viewList.addAll(cache.getState().getElementViews().values());
        viewList.addAll(OpenCms.getWorkplaceManager().getExplorerTypeViews().values());
        Collections.sort(viewList, new CmsElementView.ElementViewComparator());
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (CmsElementView viewValue : viewList) {
            result.put(viewValue.getId(), viewValue);
        }
        return result;
    }

    public I_CmsResourceType getElementViewType() {
        return this.m_elementViewType;
    }

    public List<CmsContainerElementBean> getFavoriteList(CmsObject cms) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_FAVORITE_LIST);
        ArrayList<CmsContainerElementBean> favList = new ArrayList<CmsContainerElementBean>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        favList.add(this.elementFromJson(array.getJSONObject(i)));
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        } else {
            this.saveFavoriteList(cms, favList);
        }
        return favList;
    }

    public Map<String, CmsXmlContentProperty> getFormatterSettings(CmsObject cms, CmsADEConfigData config, I_CmsFormatterBean mainFormatter, CmsResource res, Locale locale, ServletRequest req) {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        CmsXmlContentProperty.Visibility defaultVisibility = CmsXmlContentProperty.Visibility.elementAndParentIndividual;
        if (mainFormatter != null) {
            List<I_CmsFormatterBean> nestedFormatters;
            for (Map.Entry<String, CmsXmlContentProperty> entry : mainFormatter.getSettings(config).entrySet()) {
                CmsXmlContentProperty.Visibility visibility = entry.getValue().getVisibility(defaultVisibility);
                if (!visibility.isVisibleOnElement()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            if (mainFormatter.hasNestedFormatterSettings() && (nestedFormatters = this.getNestedFormatters(cms, config, res, locale, req)) != null) {
                for (I_CmsFormatterBean formatter : nestedFormatters) {
                    for (Map.Entry<String, CmsXmlContentProperty> entry : formatter.getSettings(config).entrySet()) {
                        CmsXmlContentProperty.Visibility visibility = entry.getValue().getVisibility(defaultVisibility);
                        switch (visibility) {
                            case parentShared: 
                            case elementAndParentShared: {
                                result.put(entry.getKey(), entry.getValue());
                                break;
                            }
                            case elementAndParentIndividual: 
                            case parentIndividual: {
                                String settingName = formatter.getKeyOrId() + "_" + entry.getKey();
                                CmsXmlContentProperty settingConf = entry.getValue().withName(settingName);
                                result.put(settingName, settingConf);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public CmsInheritedContainerState getInheritedContainerState(CmsObject cms, CmsResource resource, String name) {
        String rootPath = resource.getRootPath();
        if (!resource.isFolder()) {
            rootPath = CmsResource.getParentFolder(rootPath);
        }
        CmsInheritedContainerState result = new CmsInheritedContainerState();
        boolean online = this.isOnline(cms);
        CmsContainerConfigurationCache cache = online ? this.m_onlineContainerConfigurationCache : this.m_offlineContainerConfigurationCache;
        result.addConfigurations(cache, rootPath, name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsInheritedContainerState getInheritedContainerState(CmsObject cms, String rootPath, String name) throws CmsException {
        String oldSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("");
            CmsResource resource = cms.readResource(rootPath);
            CmsInheritedContainerState cmsInheritedContainerState = this.getInheritedContainerState(cms, resource, name);
            return cmsInheritedContainerState;
        }
        finally {
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
        }
    }

    public int getMaxSitemapDepth() {
        return 20;
    }

    public I_CmsResourceType getModuleConfigurationType() {
        return this.m_moduleConfigType;
    }

    public List<I_CmsFormatterBean> getNestedFormatters(CmsObject cms, CmsADEConfigData config, CmsResource res, Locale locale, ServletRequest req) {
        ArrayList<I_CmsFormatterBean> result = null;
        if (CmsResourceTypeXmlContent.isXmlContent(res)) {
            CmsResourceTypeXmlContent type = (CmsResourceTypeXmlContent)OpenCms.getResourceManager().getResourceType(res);
            String schema = type.getSchema();
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
                I_CmsXmlContentHandler handler = contentDefinition.getContentHandler();
                if (handler.hasNestedFormatters()) {
                    result = new ArrayList<I_CmsFormatterBean>();
                    for (String formatterId : handler.getNestedFormatters(cms, res, locale, req)) {
                        I_CmsFormatterBean formatter = config.findFormatter(formatterId);
                        if (formatter == null) continue;
                        result.add(formatter);
                    }
                }
            }
            catch (CmsXmlException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Stream<CmsResource> getOfflineElementUses(CmsResource resource) {
        if (resource == null || resource.getStructureId().isNullUUID()) {
            return Stream.of(new CmsResource[0]);
        }
        try {
            List<CmsRelation> relations = this.m_offlineCms.readRelations(CmsRelationFilter.relationsToStructureId(resource.getStructureId()));
            return relations.stream().flatMap(rel -> {
                try {
                    CmsResource source = rel.getSource(this.m_offlineCms, CmsResourceFilter.ALL);
                    return Stream.of(source);
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return Stream.of(new CmsResource[0]);
                }
            }).filter(source -> CmsResourceTypeXmlContainerPage.isContainerPage(source) || CmsResourceTypeXmlContainerPage.isModelGroup(source) || OpenCms.getResourceManager().matchResourceType("groupcontainer", source.getTypeId()));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Stream.of(new CmsResource[0]);
        }
    }

    public Map<String, String> getParameters(CmsObject cms) {
        String userParamsStr;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.m_parameters);
        if (cms != null && (userParamsStr = (String)cms.getRequestContext().getCurrentUser().getAdditionalInfo().get("ADE_PARAMS")) != null) {
            Map<String, String> userParams = CmsStringUtil.splitAsMap(userParamsStr, "|", ":");
            result.putAll(userParams);
        }
        return result;
    }

    public String getParentFolderType(boolean online, String rootPath) {
        return this.getCacheState(online).getParentFolderType(rootPath);
    }

    public CmsPermissionInfo getPermissionInfo(CmsObject cms, CmsResource resource, String contextPath) throws CmsException {
        boolean hasView = cms.hasPermissions(resource, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ALL.addRequireVisible());
        boolean hasWrite = false;
        if (hasView) {
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
                CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
                boolean bl = hasView = settings == null || settings.getAccess().getPermissions(cms, resource).requiresViewPermission();
                if (hasView && CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                    Object localConfigData;
                    if (contextPath == null) {
                        contextPath = resource.getRootPath();
                    }
                    if ((localConfigData = this.lookupConfigurationWithCache(cms, contextPath).getResourceType(type.getTypeName())) != null) {
                        Map<CmsUUID, CmsElementView> elementViews = this.getElementViews(cms);
                        hasView = elementViews.containsKey(((CmsResourceTypeConfig)localConfigData).getElementView()) && elementViews.get(((CmsResourceTypeConfig)localConfigData).getElementView()).hasPermission(cms, resource);
                    }
                }
                hasWrite = hasView && cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION) && (settings == null || settings.getAccess().getPermissions(cms, resource).requiresWritePermission());
            }
            catch (CmsLoaderException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                hasWrite = false;
            }
        }
        if (hasWrite && this.isEditorRestricted(cms, resource)) {
            hasWrite = false;
        }
        String noEdit = new CmsResourceUtil(cms, resource).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms), true);
        boolean isFunction = false;
        for (String type : new String[]{"function", "function_config"}) {
            if (!OpenCms.getResourceManager().matchResourceType(type, resource.getTypeId())) continue;
            isFunction = true;
            break;
        }
        if (isFunction) {
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            noEdit = Messages.get().getBundle(locale).key("GUI_CANT_EDIT_FUNCTIONS_0");
        }
        return new CmsPermissionInfo(hasView, hasWrite, noEdit);
    }

    public Map<String, List<CmsTemplatePluginWrapper>> getPluginsForPath(CmsObject cms, String path) {
        CmsADEConfigData config = this.lookupConfigurationWithCache(cms, cms.getRequestContext().addSiteRoot(path));
        Multimap<String, CmsTemplatePlugin> plugins = CmsTemplatePluginFinder.getActiveTemplatePluginsFromSitePlugins(config);
        HashMap result = new HashMap();
        for (String key : plugins.keySet()) {
            List wrappers = plugins.get((Object)key).stream().map(plugin -> new CmsTemplatePluginWrapper(cms, (CmsTemplatePlugin)plugin)).collect(Collectors.toList());
            result.put(key, Collections.unmodifiableList(wrappers));
        }
        return Collections.unmodifiableMap(result);
    }

    public List<CmsDetailPageInfo> getRawDetailPages(CmsObject cms) {
        return this.getCache(cms.getRequestContext().getCurrentProject().isOnlineProject()).getRawDetailPages();
    }

    public List<CmsContainerElementBean> getRecentList(CmsObject cms) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_RECENT_LIST);
        ArrayList<CmsContainerElementBean> recentList = new ArrayList<CmsContainerElementBean>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        recentList.add(this.elementFromJson(array.getJSONObject(i)));
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        } else {
            this.saveRecentList(cms, recentList);
        }
        return recentList;
    }

    public Map<String, String> getSitemapAttributeValuesByPath(CmsObject cms, String attribute) {
        boolean online = null == cms || this.isOnline(cms);
        CmsADEConfigCacheState state = this.getCacheState(online);
        return state.getAttributeValuesByPath(attribute);
    }

    public I_CmsResourceType getSitemapConfigurationType() {
        return this.m_configType;
    }

    public List<I_CmsSitemapExtraInfoProvider> getSitemapExtraInfoProviders() {
        return this.m_sitemapExtraInfoProviders.stream().sorted(Comparator.comparing(provider -> provider.getOrder())).collect(Collectors.toList());
    }

    public List<String> getSubSitePaths(CmsObject cms, String subSiteRoot) {
        ArrayList<String> result = new ArrayList<String>();
        String normalizedRootPath = CmsStringUtil.joinPaths("/", subSiteRoot, "/");
        CmsADEConfigCacheState state = this.getCacheState(this.isOnline(cms));
        Set<String> siteConfigurationPaths = state.getSiteConfigurationPaths();
        for (String path : siteConfigurationPaths) {
            if (path.length() <= normalizedRootPath.length() || !path.startsWith(normalizedRootPath)) continue;
            result.add(path);
        }
        return result;
    }

    public String getSubSiteRoot(CmsObject cms, String rootPath) {
        CmsADEConfigData configData = this.lookupConfiguration(cms, rootPath);
        String basePath = configData.getBasePath();
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath);
        if (siteRoot == null) {
            siteRoot = "";
        }
        if (basePath == null || !basePath.startsWith(siteRoot)) {
            return siteRoot;
        }
        return basePath;
    }

    public List<String> getSubsitesForSiteSelector(boolean online) {
        return this.getCacheState(online).getSubsitesForSiteSelector();
    }

    public CmsUploadWarningTable getUploadWarningTable() {
        return this.m_uploadWarningTable;
    }

    public void handleHtmlRedirect(CmsObject userCms, HttpServletRequest request, HttpServletResponse response, String htmlRedirect) throws CmsException {
        Integer errorCode;
        CmsObject cms = OpenCms.initCmsObject(this.m_offlineCms);
        CmsRequestContext userContext = userCms.getRequestContext();
        CmsRequestContext currentContext = cms.getRequestContext();
        currentContext.setCurrentProject(userContext.getCurrentProject());
        currentContext.setSiteRoot(userContext.getSiteRoot());
        currentContext.setLocale(userContext.getLocale());
        currentContext.setUri(userContext.getUri());
        CmsFile file = cms.readFile(htmlRedirect);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
        ArrayList<Locale> candidates = new ArrayList<Locale>();
        candidates.add(currentContext.getLocale());
        candidates.add(CmsLocaleManager.getDefaultLocale());
        candidates.add(Locale.ENGLISH);
        candidates.addAll(content.getLocales());
        Locale contentLocale = currentContext.getLocale();
        for (Locale candidateLocale : candidates) {
            if (!content.hasLocale(candidateLocale)) continue;
            contentLocale = candidateLocale;
            break;
        }
        String typeValue = content.getValue(N_TYPE, contentLocale).getStringValue(cms);
        String lnkUri = "";
        if ("sublevel".equals(typeValue)) {
            CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
            if (navBuilder.getNavigationForFolder().size() > 0) {
                CmsJspNavElement target = navBuilder.getNavigationForFolder().get(0);
                lnkUri = CmsJspTagLink.linkTagAction(target.getResourceName(), (ServletRequest)request);
                errorCode = 302;
            } else {
                errorCode = 404;
            }
        } else {
            I_CmsXmlContentValue contentValue = content.getValue(N_LINK, contentLocale);
            if (contentValue != null) {
                String linkValue = contentValue.getStringValue(cms);
                lnkUri = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, linkValue);
                try {
                    errorCode = Integer.valueOf(typeValue);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    errorCode = 307;
                }
            } else {
                errorCode = 404;
            }
        }
        if (!currentContext.getCurrentProject().isOnlineProject() && errorCode == 301) {
            errorCode = 302;
        }
        request.setAttribute("org.opencms.util.CmsErrorCode", (Object)errorCode);
        response.setHeader("Location", CmsEncoder.convertHostToPunycode(lnkUri));
        response.setHeader("Connection", "close");
        response.setStatus(errorCode.intValue());
    }

    public synchronized void initialize() {
        if (this.m_initStatus == Status.notInitialized && OpenCms.getModuleManager().hasModule(MODULE_NAME_ADE_CONFIG)) {
            try {
                CmsLog.INIT.info((Object)". Initializing the ADE configuration, this may take a while...");
                this.m_initStatus = Status.initializing;
                this.m_configType = OpenCms.getResourceManager().getResourceType(CONFIG_TYPE);
                this.m_moduleConfigType = OpenCms.getResourceManager().getResourceType(MODULE_CONFIG_TYPE);
                this.m_elementViewType = OpenCms.getResourceManager().getResourceType(ELEMENT_VIEW_TYPE);
                CmsProject temp = this.getTempfileProject(this.m_onlineCms);
                this.m_offlineCms = OpenCms.initCmsObject(this.m_onlineCms);
                this.m_offlineCms.getRequestContext().setCurrentProject(temp);
                this.m_onlineCache = new CmsConfigurationCache(this.m_onlineCms, this.m_configType, this.m_moduleConfigType, this.m_elementViewType);
                this.m_offlineCache = new CmsConfigurationCache(this.m_offlineCms, this.m_configType, this.m_moduleConfigType, this.m_elementViewType);
                CmsLog.INIT.info((Object)". Reading online configuration...");
                this.m_onlineCache.initialize();
                CmsLog.INIT.info((Object)". Reading offline configuration...");
                this.m_offlineCache.initialize();
                this.m_onlineContainerConfigurationCache = new CmsContainerConfigurationCache(this.m_onlineCms, "online inheritance groups");
                this.m_offlineContainerConfigurationCache = new CmsContainerConfigurationCache(this.m_offlineCms, "offline inheritance groups");
                CmsLog.INIT.info((Object)". Reading online inherited container configurations...");
                this.m_onlineContainerConfigurationCache.initialize();
                CmsLog.INIT.info((Object)". Reading offline inherited container configurations...");
                this.m_offlineContainerConfigurationCache.initialize();
                this.m_offlineFormatterCache = new CmsFormatterConfigurationCache(this.m_offlineCms, "offline formatters");
                this.m_onlineFormatterCache = new CmsFormatterConfigurationCache(this.m_onlineCms, "online formatters");
                CmsLog.INIT.info((Object)". Reading online formatter configurations...");
                this.m_onlineFormatterCache.initialize();
                CmsLog.INIT.info((Object)". Reading offline formatter configurations...");
                this.m_offlineFormatterCache.initialize();
                this.m_offlineDetailIdCache = new CmsDetailNameCache(this.m_offlineCms);
                this.m_onlineDetailIdCache = new CmsDetailNameCache(this.m_onlineCms);
                CmsLog.INIT.info((Object)". Initializing online detail name cache...");
                this.m_onlineDetailIdCache.initialize();
                CmsLog.INIT.info((Object)". Initializing offline detail name cache...");
                this.m_offlineDetailIdCache.initialize();
                CmsGlobalConfigurationCacheEventHandler handler = new CmsGlobalConfigurationCacheEventHandler(this.m_onlineCms);
                handler.addCache(this.m_offlineCache, this.m_onlineCache, "ADE configuration cache");
                handler.addCache(this.m_offlineContainerConfigurationCache, this.m_onlineContainerConfigurationCache, "Inherited container cache");
                handler.addCache(this.m_offlineFormatterCache, this.m_onlineFormatterCache, "formatter configuration cache");
                handler.addCache(this.m_offlineDetailIdCache, this.m_onlineDetailIdCache, "Detail ID cache");
                OpenCms.getEventManager().addCmsEventListener(handler);
                CmsLog.INIT.info((Object)". Done initializing the ADE configuration.");
                this.m_initStatus = Status.initialized;
            }
            catch (CmsException e) {
                this.m_initStatus = Status.notInitialized;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_detailPageHandler.initialize(this.m_offlineCms, this.m_onlineCms);
        }
    }

    public boolean isDetailPage(CmsObject cms, CmsResource resource) {
        return this.getCache(this.isOnline(cms)).isDetailPage(cms, resource);
    }

    public boolean isEditorRestricted(CmsObject cms, CmsResource res) {
        CmsRole role;
        return OpenCms.getResourceManager().matchResourceType(CONFIG_TYPE, res.getTypeId()) && (role = this.getRoleForSitemapConfigEditing()) != null && !OpenCms.getRoleManager().hasRoleForResource(cms, role, res);
    }

    public boolean isElementReused(CmsResource resource, Predicate<CmsResource> exclude) {
        return this.getOfflineElementUses(resource).anyMatch(source -> !exclude.test((CmsResource)source));
    }

    public boolean isInitialized() {
        return this.m_initStatus == Status.initialized;
    }

    public boolean isShowEditorHelp(CmsObject cms) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String showHelp = (String)user.getAdditionalInfo(ADDINFO_ADE_SHOW_EDITOR_HELP);
        return CmsStringUtil.isEmptyOrWhitespaceOnly(showHelp) || Boolean.parseBoolean(showHelp);
    }

    public CmsADEConfigData lookupConfiguration(CmsObject cms, String rootPath) {
        CmsADEConfigData configData = this.internalLookupConfiguration(cms, rootPath);
        return configData;
    }

    public CmsADEConfigData lookupConfigurationWithCache(CmsObject cms, String rootPath) {
        boolean online = cms == null || cms.getRequestContext().getCurrentProject().isOnlineProject();
        String cacheKey = online + ":" + rootPath;
        OpenCmsServlet.RequestCache context = OpenCmsServlet.getRequestCache();
        CmsADEConfigData result = null;
        if (context != null) {
            result = context.getCachedConfig(cacheKey);
        }
        if (result == null) {
            result = this.internalLookupConfiguration(cms, rootPath);
            if (context != null) {
                context.setCachedConfig(cacheKey, result);
            }
        }
        return result;
    }

    public void refresh() {
        this.m_onlineCache.initialize();
        this.m_offlineCache.initialize();
    }

    public void removeSitemapExtraInfoProvider(I_CmsSitemapExtraInfoProvider provider) {
        this.m_sitemapExtraInfoProviders.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDetailPages(CmsObject cms, String rootPath, List<CmsDetailPageInfo> detailPages, CmsUUID newId) throws CmsException {
        CmsADEConfigData configData = this.lookupConfiguration(cms, rootPath);
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("");
            if (configData.isModuleConfiguration()) {
                boolean bl = false;
                return bl;
            }
            CmsResource configFile = configData.getResource();
            CmsDetailPageConfigurationWriter configWriter = new CmsDetailPageConfigurationWriter(cms, configFile);
            configWriter.updateAndSave(detailPages, newId);
            boolean bl = true;
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    public void saveFavoriteList(CmsObject cms, List<CmsContainerElementBean> favoriteList) throws CmsException {
        this.saveElementList(cms, favoriteList, ADDINFO_ADE_FAVORITE_LIST);
    }

    public void saveInheritedContainer(CmsObject cms, CmsResource pageResource, String name, boolean newOrder, List<CmsContainerElementBean> elements) throws CmsException {
        CmsContainerConfigurationWriter writer = new CmsContainerConfigurationWriter();
        writer.save(cms, name, newOrder, pageResource, elements);
        this.m_offlineContainerConfigurationCache.flushUpdates();
    }

    public void saveInheritedContainer(CmsObject cms, String sitePath, String name, boolean newOrder, List<CmsContainerElementBean> elements) throws CmsException {
        this.saveInheritedContainer(cms, cms.readResource(sitePath), name, newOrder, elements);
    }

    public void saveRecentList(CmsObject cms, List<CmsContainerElementBean> recentList) throws CmsException {
        this.saveElementList(cms, recentList, ADDINFO_ADE_RECENT_LIST);
    }

    public void setShowEditorHelp(CmsObject cms, boolean showHelp) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        user.setAdditionalInfo(ADDINFO_ADE_SHOW_EDITOR_HELP, String.valueOf(showHelp));
        cms.writeUser(user);
    }

    public void shutdown() {
    }

    public void waitForCacheUpdate(boolean online) {
        this.getCache(online).getWaitHandleForUpdateTask().enter(6000L);
    }

    public void waitForFormatterCache(boolean online) {
        CmsFormatterConfigurationCache cache = online ? this.m_onlineFormatterCache : this.m_offlineFormatterCache;
        cache.waitForUpdate();
    }

    protected CmsContainerElementBean elementFromJson(JSONObject data) throws JSONException {
        CmsUUID element = new CmsUUID(data.getString(FavListProp.ELEMENT.name().toLowerCase()));
        CmsUUID formatter = null;
        if (data.has(FavListProp.FORMATTER.name().toLowerCase())) {
            formatter = new CmsUUID(data.getString(FavListProp.FORMATTER.name().toLowerCase()));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        JSONObject props = data.getJSONObject(FavListProp.PROPERTIES.name().toLowerCase());
        Iterator<String> keys = props.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            properties.put(key, props.getString(key));
        }
        return new CmsContainerElementBean(element, formatter, properties, false);
    }

    protected JSONObject elementToJson(CmsContainerElementBean element, Set<String> excludeSettings) {
        JSONObject data = null;
        try {
            data = new JSONObject();
            data.put(FavListProp.ELEMENT.name().toLowerCase(), element.getId().toString());
            if (element.getFormatterId() != null) {
                data.put(FavListProp.FORMATTER.name().toLowerCase(), element.getFormatterId().toString());
            }
            JSONObject properties = new JSONObject();
            for (Map.Entry<String, String> entry : element.getIndividualSettings().entrySet()) {
                String settingKey = entry.getKey();
                if (excludeSettings.contains(settingKey)) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
            data.put(FavListProp.PROPERTIES.name().toLowerCase(), properties);
        }
        catch (JSONException e) {
            if (!LOG.isDebugEnabled()) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        return data;
    }

    protected CmsConfigurationCache getCache(boolean online) {
        return online ? this.m_onlineCache : this.m_offlineCache;
    }

    protected CmsConfigurationCache getOfflineCache() {
        return this.m_offlineCache;
    }

    protected CmsConfigurationCache getOnlineCache() {
        return this.m_onlineCache;
    }

    protected CmsRole getRoleForSitemapConfigEditing() {
        String roleName = OpenCms.getWorkplaceManager().getSitemapConfigEditRole();
        if (roleName == null) {
            return null;
        }
        if (roleName.indexOf("/") == -1) {
            return CmsRole.valueOfRoleName(roleName).forOrgUnit(null);
        }
        return CmsRole.valueOfRoleName(roleName);
    }

    protected String getRootPath(CmsUUID structureId, boolean online) throws CmsException {
        CmsConfigurationCache cache = online ? this.m_onlineCache : this.m_offlineCache;
        return cache.getPathForStructureId(structureId);
    }

    protected CmsProject getTempfileProject(CmsObject cms) throws CmsException {
        try {
            return cms.readProject("tempFileProject");
        }
        catch (CmsException e) {
            return cms.createTempfileProject();
        }
    }

    protected CmsADEConfigData internalLookupConfiguration(CmsObject cms, String rootPath) {
        boolean online = null == cms || this.isOnline(cms);
        CmsADEConfigCacheState state = this.getCacheState(online);
        return state.lookupConfiguration(rootPath);
    }

    private boolean isOnline(CmsObject cms) {
        return cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    private void saveElementList(CmsObject cms, List<CmsContainerElementBean> elementList, String listKey) throws CmsException {
        if (elementList.size() > 10) {
            elementList = elementList.subList(0, 10);
        }
        JSONArray data = new JSONArray();
        HashSet<String> excludedSettings = new HashSet<String>();
        excludedSettings.add("templateContexts");
        for (CmsContainerElementBean element : elementList) {
            data.put(this.elementToJson(element, excludedSettings));
        }
        CmsUser user = cms.getRequestContext().getCurrentUser();
        user.setAdditionalInfo(listKey, data.toString());
        cms.writeUser(user);
    }

    protected static enum Status {
        initialized,
        initializing,
        notInitialized;

    }

    protected static enum FavListProp {
        ELEMENT,
        FORMATTER,
        PROPERTIES;

    }
}

