/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.file.CmsResource;

public class CmsADEConfigurationSequence {
    private List<CmsADEConfigDataInternal.ConfigReferenceInstance> m_configDatas;
    private int m_configIndex;

    public CmsADEConfigurationSequence(List<CmsADEConfigDataInternal.ConfigReferenceInstance> configDatas) {
        this(configDatas, configDatas.size() - 1);
    }

    protected CmsADEConfigurationSequence(List<CmsADEConfigDataInternal.ConfigReferenceInstance> configDatas, int index) {
        assert (0 <= index && index < configDatas.size());
        this.m_configDatas = configDatas;
        this.m_configIndex = index;
    }

    public CmsADEConfigDataInternal getConfig() {
        return this.m_configDatas.get(this.m_configIndex).getConfig();
    }

    public List<String> getConfigPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i <= this.m_configIndex; ++i) {
            CmsResource res = this.m_configDatas.get(i).getConfig().getResource();
            if (res == null) continue;
            result.add(res.getRootPath());
        }
        return Collections.unmodifiableList(result);
    }

    public CmsADEConfigDataInternal.ConfigReferenceMeta getMeta() {
        return this.m_configDatas.get(this.m_configIndex).getMeta();
    }

    public Optional<CmsADEConfigurationSequence> getParent() {
        if (this.m_configIndex <= 0) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)new CmsADEConfigurationSequence(this.m_configDatas, this.m_configIndex - 1));
    }
}

