/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsModificationContext;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsStringUtil;

public class CmsContentTest
extends CmsJspActionElement {
    private static final String BASE_FOLDER = "/shared/online/test";
    private static final Log LOG = CmsLog.getLog(CmsContentTest.class);

    public CmsContentTest(PageContext pageContext, HttpServletRequest request, HttpServletResponse response) {
        super(pageContext, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String name) throws Exception {
        int count = 500;
        long start = System.currentTimeMillis();
        try {
            CmsObject cms = this.getCmsObject();
            cms.lockResourceTemporary(BASE_FOLDER);
            String folder = CmsStringUtil.joinPaths(BASE_FOLDER, name);
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType("m-section");
                String contentTemplate = "";
                try (InputStream stream = this.getClass().getResourceAsStream("example.xml");){
                    contentTemplate = new String(contentTemplate.getBytes(), StandardCharsets.UTF_8);
                }
                String finalTemplate = contentTemplate;
                cms.createResource(folder, OpenCms.getResourceManager().getResourceType("folder"));
                int i = 0;
                while (i < count) {
                    int finalI = i++;
                    CmsModificationContext.doWithModificationContext(cms.getRequestContext(), () -> {
                        byte[] content = finalTemplate.replace("NUMBER", "" + finalI).getBytes(StandardCharsets.UTF_8);
                        String path = CmsStringUtil.joinPaths(folder, "content_" + finalI + ".xml");
                        cms.createResource(path, type, content, new ArrayList<CmsProperty>());
                        CmsCategoryService.getInstance().addResourceToCategory(cms, path, "foo");
                        CmsCategoryService.getInstance().addResourceToCategory(cms, path, "bar");
                        return null;
                    });
                }
                OpenCms.getPublishManager().publishProject(cms);
                OpenCms.getPublishManager().waitWhileRunning();
            }
            finally {
                cms.unlockResource(BASE_FOLDER);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println("DURATION: " + (end - start));
        }
    }
}

