/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import java.util.Date;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.util.CmsUUID;

public class A_CmsSerialDateValue
implements I_CmsSerialDateValue {
    private Date m_start;
    private Date m_end;
    private Date m_seriesEndDate;
    private int m_seriesOccurrences;
    private int m_interval;
    private int m_dayOfMonth;
    private final SortedSet<I_CmsSerialDateValue.WeekDay> m_weekDays = new TreeSet<I_CmsSerialDateValue.WeekDay>();
    private I_CmsSerialDateValue.PatternType m_patterntype;
    private final SortedSet<I_CmsSerialDateValue.WeekOfMonth> m_weeksOfMonth = new TreeSet<I_CmsSerialDateValue.WeekOfMonth>();
    private final SortedSet<Date> m_exceptions = new TreeSet<Date>();
    private final SortedSet<Date> m_individualDates = new TreeSet<Date>();
    private boolean m_isEveryWorkingDay;
    private boolean m_isWholeDay;
    private I_CmsSerialDateValue.Month m_month = I_CmsSerialDateValue.Month.JANUARY;
    private I_CmsSerialDateValue.EndType m_endType;
    private CmsUUID m_parentSeriesId;
    private boolean m_currentTillEnd = true;

    public void addException(Date date) {
        if (null != date) {
            this.m_exceptions.add(date);
        }
    }

    public final void addWeekOfMonth(I_CmsSerialDateValue.WeekOfMonth week) {
        this.m_weeksOfMonth.add(week);
    }

    public final void clearExceptions() {
        this.m_exceptions.clear();
    }

    public final void clearIndividualDates() {
        this.m_individualDates.clear();
    }

    public final void clearWeekDays() {
        this.m_weekDays.clear();
    }

    public final void clearWeeksOfMonth() {
        this.m_weeksOfMonth.clear();
    }

    @Override
    public boolean endsAtMidNight() {
        Date end = this.getEnd();
        return end != null && end.getHours() == 0 && end.getMinutes() == 0 && end.getSeconds() == 0 && end.getTime() % 1000L == 0L;
    }

    public final boolean equals(Object o) {
        if (o instanceof I_CmsSerialDateValue) {
            I_CmsSerialDateValue val = (I_CmsSerialDateValue)o;
            return val.getDayOfMonth() == this.getDayOfMonth() && val.isEveryWorkingDay() == this.isEveryWorkingDay() && val.isWholeDay() == this.isWholeDay() && Objects.equals(val.getEnd(), this.getEnd()) && Objects.equals((Object)val.getEndType(), (Object)this.getEndType()) && Objects.equals(val.getExceptions(), this.getExceptions()) && Objects.equals(val.getIndividualDates(), this.getIndividualDates()) && val.getInterval() == this.getInterval() && Objects.equals((Object)val.getMonth(), (Object)this.getMonth()) && val.getOccurrences() == this.getOccurrences() && Objects.equals((Object)val.getPatternType(), (Object)this.getPatternType()) && Objects.equals(val.getSeriesEndDate(), this.getSeriesEndDate()) && Objects.equals(val.getStart(), this.getStart()) && Objects.equals((Object)val.getWeekDay(), (Object)this.getWeekDay()) && Objects.equals(val.getWeekDays(), this.getWeekDays()) && Objects.equals((Object)val.getWeekOfMonth(), (Object)this.getWeekOfMonth()) && Objects.equals(val.getWeeksOfMonth(), this.getWeeksOfMonth()) && Objects.equals(val.getParentSeriesId(), this.getParentSeriesId());
        }
        return false;
    }

    @Override
    public I_CmsSerialDateValue.DateType getDateType() {
        if (!Objects.equals((Object)this.getPatternType(), (Object)I_CmsSerialDateValue.PatternType.NONE)) {
            return I_CmsSerialDateValue.DateType.SERIES;
        }
        if (this.isFromOtherSeries()) {
            return I_CmsSerialDateValue.DateType.EXTRACTED;
        }
        return I_CmsSerialDateValue.DateType.SINGLE;
    }

    @Override
    public final int getDayOfMonth() {
        return this.m_dayOfMonth;
    }

    @Override
    public final Date getEnd() {
        return this.m_end;
    }

    @Override
    public final I_CmsSerialDateValue.EndType getEndType() {
        return this.m_endType;
    }

    @Override
    public final SortedSet<Date> getExceptions() {
        return new TreeSet<Date>(this.m_exceptions);
    }

    @Override
    public final SortedSet<Date> getIndividualDates() {
        return new TreeSet<Date>(this.m_individualDates);
    }

    @Override
    public final int getInterval() {
        return this.m_interval;
    }

    @Override
    public final I_CmsSerialDateValue.Month getMonth() {
        return this.m_month;
    }

    @Override
    public final int getOccurrences() {
        return this.m_seriesOccurrences;
    }

    @Override
    public CmsUUID getParentSeriesId() {
        return this.m_parentSeriesId;
    }

    @Override
    public final I_CmsSerialDateValue.PatternType getPatternType() {
        return this.m_patterntype;
    }

    @Override
    public final Date getSeriesEndDate() {
        return this.m_seriesEndDate;
    }

    @Override
    public final Date getStart() {
        return this.m_start;
    }

    @Override
    public final I_CmsSerialDateValue.WeekDay getWeekDay() {
        if (this.m_weekDays.size() > 0) {
            return this.m_weekDays.first();
        }
        return null;
    }

    @Override
    public final SortedSet<I_CmsSerialDateValue.WeekDay> getWeekDays() {
        return new TreeSet<I_CmsSerialDateValue.WeekDay>(this.m_weekDays);
    }

    @Override
    public final I_CmsSerialDateValue.WeekOfMonth getWeekOfMonth() {
        if (this.m_weeksOfMonth.size() > 0) {
            return (I_CmsSerialDateValue.WeekOfMonth)((Object)this.m_weeksOfMonth.iterator().next());
        }
        return null;
    }

    @Override
    public final SortedSet<I_CmsSerialDateValue.WeekOfMonth> getWeeksOfMonth() {
        return new TreeSet<I_CmsSerialDateValue.WeekOfMonth>(this.m_weeksOfMonth);
    }

    public final boolean hasExceptions() {
        return !this.getExceptions().isEmpty();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.isEveryWorkingDay(), this.isWholeDay(), this.getDayOfMonth(), this.getEnd(), this.getEndType(), this.getExceptions(), this.getIndividualDates(), this.getInterval(), this.getMonth(), this.getOccurrences(), this.getPatternType(), this.getSeriesEndDate(), this.getStart(), this.getWeekDay(), this.getWeekDays(), this.getWeekOfMonth(), this.getWeeksOfMonth(), this.isCurrentTillEnd(), this.getParentSeriesId()});
    }

    @Override
    public boolean isCurrentTillEnd() {
        return this.m_currentTillEnd;
    }

    @Override
    public final boolean isEveryWorkingDay() {
        return this.m_isEveryWorkingDay;
    }

    @Override
    public boolean isFromOtherSeries() {
        return null != this.m_parentSeriesId;
    }

    @Override
    public final boolean isValid() {
        return this.isStartSet() && this.isEndValid() && this.isPatternValid() && this.isDurationValid();
    }

    @Override
    public final boolean isWholeDay() {
        return this.m_isWholeDay;
    }

    public final void removeWeekOfMonth(I_CmsSerialDateValue.WeekOfMonth week) {
        this.m_weeksOfMonth.remove((Object)week);
    }

    public final void setCurrentTillEnd(Boolean isCurrentTillEnd) {
        this.m_currentTillEnd = null == isCurrentTillEnd || isCurrentTillEnd != false;
    }

    public final void setDayOfMonth(int dayOfMonth) {
        this.m_dayOfMonth = dayOfMonth;
    }

    public final void setEnd(Date date) {
        this.m_end = date;
    }

    public final void setEndType(I_CmsSerialDateValue.EndType endType) {
        this.m_endType = null == endType ? I_CmsSerialDateValue.EndType.SINGLE : endType;
    }

    public final void setEveryWorkingDay(Boolean isEveryWorkingDay) {
        this.m_isEveryWorkingDay = null == isEveryWorkingDay ? false : isEveryWorkingDay;
    }

    public final void setExceptions(SortedSet<Date> dates) {
        this.m_exceptions.clear();
        if (null != dates) {
            this.m_exceptions.addAll(dates);
        }
    }

    public final void setIndividualDates(SortedSet<Date> dates) {
        this.m_individualDates.clear();
        if (null != dates) {
            this.m_individualDates.addAll(dates);
        }
        for (Date d : this.getExceptions()) {
            if (this.m_individualDates.contains(d)) continue;
            this.m_exceptions.remove(d);
        }
    }

    public final void setInterval(int interval) {
        this.m_interval = interval;
    }

    public final void setMonth(I_CmsSerialDateValue.Month month) {
        this.m_month = null == month ? I_CmsSerialDateValue.Month.JANUARY : month;
    }

    public final void setOccurrences(int occurrences) {
        this.m_seriesOccurrences = occurrences;
    }

    public final void setParentSeriesId(CmsUUID structureId) {
        this.m_parentSeriesId = structureId;
    }

    public final void setPatternType(I_CmsSerialDateValue.PatternType type) {
        this.m_patterntype = null == type ? I_CmsSerialDateValue.PatternType.NONE : type;
    }

    public final void setSeriesEndDate(Date date) {
        this.m_seriesEndDate = date;
    }

    public final void setStart(Date date) {
        this.m_start = date;
    }

    public final void setWeekDay(I_CmsSerialDateValue.WeekDay weekDay) {
        TreeSet<I_CmsSerialDateValue.WeekDay> wds = new TreeSet<I_CmsSerialDateValue.WeekDay>();
        if (null != weekDay) {
            wds.add(weekDay);
        }
        this.setWeekDays(wds);
    }

    public final void setWeekDays(SortedSet<I_CmsSerialDateValue.WeekDay> weekDays) {
        this.m_weekDays.clear();
        if (null != weekDays) {
            this.m_weekDays.addAll(weekDays);
        }
    }

    public final void setWeekOfMonth(I_CmsSerialDateValue.WeekOfMonth weekOfMonth) {
        TreeSet<I_CmsSerialDateValue.WeekOfMonth> woms = new TreeSet<I_CmsSerialDateValue.WeekOfMonth>();
        if (null != weekOfMonth) {
            woms.add(weekOfMonth);
        }
        this.setWeeksOfMonth(woms);
    }

    public final void setWeeksOfMonth(SortedSet<I_CmsSerialDateValue.WeekOfMonth> weeksOfMonth) {
        this.m_weeksOfMonth.clear();
        if (null != weeksOfMonth) {
            this.m_weeksOfMonth.addAll(weeksOfMonth);
        }
    }

    public final void setWholeDay(Boolean isWholeDay) {
        this.m_isWholeDay = null != isWholeDay && isWholeDay.equals(Boolean.TRUE);
    }

    protected final boolean isDayOfMonthValid() {
        return this.getDayOfMonth() > 0 && this.getDayOfMonth() <= (this.getMonth() == null ? 31 : this.getMonth().getMaximalDay());
    }

    protected final boolean isDurationValid() {
        if (this.isValidEndTypeForPattern()) {
            switch (this.getEndType()) {
                case DATE: {
                    return this.getStart().getTime() < this.getSeriesEndDate().getTime() + 86400000L;
                }
                case TIMES: {
                    return this.getOccurrences() > 0;
                }
                case SINGLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected final boolean isEndValid() {
        return this.getEnd() == null || !this.getEnd().before(this.getStart());
    }

    protected final boolean isIntervalValid() {
        return this.getInterval() > 0;
    }

    protected final boolean isMonthSet() {
        return this.getMonth() != null;
    }

    protected final boolean isPatternValid() {
        switch (this.getPatternType()) {
            case DAILY: {
                return this.isEveryWorkingDay() || this.isIntervalValid();
            }
            case WEEKLY: {
                return this.isIntervalValid() && this.isWeekDaySet();
            }
            case MONTHLY: {
                return this.isIntervalValid() && this.isWeekDaySet() ? this.isWeekOfMonthSet() : this.isDayOfMonthValid();
            }
            case YEARLY: {
                return this.isMonthSet() && this.isWeekDaySet() ? this.isWeekOfMonthSet() : this.isDayOfMonthValid();
            }
            case INDIVIDUAL: 
            case NONE: {
                return true;
            }
        }
        return false;
    }

    protected final boolean isStartSet() {
        return null != this.getStart();
    }

    protected final boolean isValidEndTypeForPattern() {
        if (this.getEndType() == null) {
            return false;
        }
        switch (this.getPatternType()) {
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return this.getEndType().equals((Object)I_CmsSerialDateValue.EndType.DATE) || this.getEndType().equals((Object)I_CmsSerialDateValue.EndType.TIMES);
            }
            case INDIVIDUAL: 
            case NONE: {
                return this.getEndType().equals((Object)I_CmsSerialDateValue.EndType.SINGLE);
            }
        }
        return false;
    }

    protected final boolean isWeekDaySet() {
        return !this.m_weekDays.isEmpty();
    }

    protected final boolean isWeekOfMonthSet() {
        return !this.m_weeksOfMonth.isEmpty();
    }

    protected final void setDefaultValue() {
        this.m_start = null;
        this.m_end = null;
        this.m_patterntype = I_CmsSerialDateValue.PatternType.NONE;
        this.m_dayOfMonth = 0;
        this.m_exceptions.clear();
        this.m_individualDates.clear();
        this.m_interval = 0;
        this.m_isEveryWorkingDay = false;
        this.m_isWholeDay = false;
        this.m_month = I_CmsSerialDateValue.Month.JANUARY;
        this.m_seriesEndDate = null;
        this.m_seriesOccurrences = 0;
        this.m_weekDays.clear();
        this.m_weeksOfMonth.clear();
        this.m_endType = I_CmsSerialDateValue.EndType.SINGLE;
        this.m_parentSeriesId = null;
    }

    protected final void setDerivedEndType() {
        this.m_endType = this.getPatternType().equals((Object)I_CmsSerialDateValue.PatternType.NONE) || this.getPatternType().equals((Object)I_CmsSerialDateValue.PatternType.INDIVIDUAL) ? I_CmsSerialDateValue.EndType.SINGLE : (null != this.getSeriesEndDate() ? I_CmsSerialDateValue.EndType.DATE : I_CmsSerialDateValue.EndType.TIMES);
    }
}

