/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class UnicodeEncodingWriter
extends FilterWriter {
    public UnicodeEncodingWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (c <= 127) {
            super.write(c);
        } else {
            super.write(92);
            super.write(117);
            String hex = Integer.toHexString(c);
            int i = hex.length();
            while (i < 4) {
                super.write(48);
                ++i;
            }
            this.write(hex);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(buf[i]);
            ++i;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }
}

