/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.util.ChecksummingReader;
import com.atlassian.clover.util.IOStreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private final long PLATFORM_FS_RESOLUTION;
    private static final int DEFAULT_FS_RESOLUTION = 1000;
    private static FileUtils INSTANCE;

    private FileUtils(long res) {
        this.PLATFORM_FS_RESOLUTION = res;
    }

    public static synchronized FileUtils getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new FileUtils(FileUtils.calcFSResolution());
        return INSTANCE;
    }

    public static File getJavaTempDir() {
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(FileUtils.JAVA_IO_TMPDIR);
            }
        });
        if (property == null) {
            throw new RuntimeException("The java.io.tmpdir system property is not set. Please ensure this property is set before executing Clover.");
        }
        return new File(property);
    }

    public long getPlatformFSResolution() {
        return this.PLATFORM_FS_RESOLUTION;
    }

    private static int calcFSResolution() {
        int n;
        block7: {
            int rez = 1;
            File temp = File.createTempFile("clover_fs_rez_test", ".txt");
            try {
                AccessController.checkPermission(new FilePermission(temp.getAbsolutePath(), "delete"));
                while (rez <= 1000) {
                    temp.setLastModified(rez);
                    if (temp.lastModified() == (long)rez) break;
                    rez *= 10;
                }
                n = rez;
                if (temp == null) break block7;
                temp.delete();
            }
            catch (Throwable throwable) {
                try {
                    if (temp != null) {
                        temp.delete();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return 1000;
                }
            }
        }
        return n;
    }

    public static void readerCopy(Reader src, Writer dest) throws IOException {
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(src);
            out = new PrintWriter(dest);
            String line = in.readLine();
            while (line != null) {
                out.println(line);
                line = in.readLine();
            }
            out.flush();
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(in);
            IOStreamUtils.close(out);
            throw throwable;
        }
        IOStreamUtils.close(in);
        IOStreamUtils.close(out);
    }

    public static void fileCopy(File src, File dest) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(Files.newInputStream(src.toPath(), new OpenOption[0]));
            out = new BufferedOutputStream(Files.newOutputStream(dest.toPath(), new OpenOption[0]));
            int b = ((InputStream)in).read();
            while (b >= 0) {
                ((OutputStream)out).write(b);
                b = ((InputStream)in).read();
            }
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(in);
            IOStreamUtils.close(out);
            throw throwable;
        }
        IOStreamUtils.close(in);
        IOStreamUtils.close(out);
    }

    public static void dirCopy(File srcDir, File destDir, boolean deleteDestDir) throws IOException {
        File[] files;
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir.getAbsolutePath() + "' is not a directory");
        }
        if (srcDir.getAbsolutePath().equals(destDir.getAbsolutePath())) {
            throw new IOException("Target '" + destDir.getAbsolutePath() + "' is same as source '" + srcDir.getAbsolutePath() + "'");
        }
        if (FileUtils.isAncestorOf(srcDir, destDir)) {
            throw new IOException("Target '" + destDir.getAbsolutePath() + "' is sub-directory of source '" + srcDir.getAbsolutePath() + "'");
        }
        if (deleteDestDir && destDir.exists() && !FileUtils.deltree(destDir)) {
            throw new IOException("Unable to delete destination directory '" + destDir.getAbsolutePath() + "'");
        }
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IOException("Failed to create destination directory '" + destDir.getAbsolutePath() + "'");
        }
        File[] fileArray = files = srcDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File destFile = new File(destDir, file.getName());
            if (file.isDirectory()) {
                FileUtils.dirCopy(file, destFile, deleteDestDir);
            } else {
                FileUtils.fileCopy(file, destFile);
            }
            ++n2;
        }
    }

    public static void inputStreamToFile(@NotNull InputStream in, @NotNull File outFile) throws IOException {
        BufferedOutputStream out = null;
        outFile.getParentFile().mkdirs();
        try {
            out = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
            FileUtils.streamCopy(in, out);
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(in);
            IOStreamUtils.close(out);
            throw throwable;
        }
        IOStreamUtils.close(in);
        IOStreamUtils.close(out);
    }

    public static void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[16384];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
    }

    public static void resourceToFile(ClassLoader classLoader, String resourcePath, File outputFile) throws IOException {
        InputStream res = classLoader.getResourceAsStream(resourcePath);
        if (res == null) {
            throw new IOException("Resource not found: " + resourcePath);
        }
        FileUtils.inputStreamToFile(res, outputFile);
    }

    public static boolean deltree(File rootDir) {
        if (rootDir.isDirectory()) {
            String[] files;
            String[] stringArray = files = rootDir.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!FileUtils.deltree(new File(rootDir, file))) {
                    return false;
                }
                ++n2;
            }
        }
        return rootDir.delete();
    }

    public static String getNormalizedPath(String inputPath) {
        return inputPath == null ? null : inputPath.replace('\\', '/');
    }

    public static String getPlatformSpecificPath(String inputPath) {
        return inputPath == null ? null : inputPath.replace('\\', '/').replace('/', File.separatorChar);
    }

    public static String getRelativePath(String a, String b, String pathSep) {
        String[] pathA = FileUtils.getPaths(a);
        String[] pathB = FileUtils.getPaths(b);
        int indexA = -1;
        int indexB = -1;
        int i = pathA.length;
        while (i > 0) {
            if (FileUtils.lastIndexOf(pathA[i - 1], pathB) != -1) {
                indexA = i - 1;
                indexB = FileUtils.lastIndexOf(pathA[i - 1], pathB);
                break;
            }
            --i;
        }
        if (indexA == -1 || indexB == -1) {
            return null;
        }
        int pathADistance = pathA.length - (indexA + 1);
        int pathBDistance = pathB.length - (indexB + 1);
        String relativePath = "";
        int i2 = 0;
        while (i2 < pathADistance) {
            relativePath = String.valueOf(relativePath) + ".." + pathSep;
            ++i2;
        }
        String[] pathBComponents = FileUtils.getPathComponents(b);
        String sep = "";
        int i3 = pathB.length - pathBDistance;
        while (i3 < pathB.length) {
            relativePath = String.valueOf(relativePath) + sep + pathBComponents[i3];
            sep = pathSep;
            ++i3;
        }
        return relativePath;
    }

    public static String getRelativePath(String a, String b) {
        return FileUtils.getRelativePath(a, b, File.separator);
    }

    public static String getRelativePath(File a, File b, String pathSep) {
        return FileUtils.getRelativePath(a.getAbsolutePath(), b.getAbsolutePath(), pathSep);
    }

    public static String getRelativePath(File a, File b) {
        return FileUtils.getRelativePath(a.getAbsolutePath(), b.getAbsolutePath(), File.separator);
    }

    public static long calcAdlerChecksum(File f, String encoding) throws IOException {
        long l;
        char[] buffer = new char[8192];
        ChecksummingReader reader = null;
        try {
            InputStreamReader in = encoding != null ? new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0]), encoding) : new FileReader(f);
            reader = new ChecksummingReader(new BufferedReader(in));
            while (reader.read(buffer) >= 0) {
            }
            l = reader.getChecksum();
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(reader);
            throw throwable;
        }
        IOStreamUtils.close(reader);
        return l;
    }

    private static int lastIndexOf(String str, String[] path) {
        int i = path.length;
        while (i > 0) {
            if (path[i - 1].compareTo(str) == 0) {
                return i - 1;
            }
            --i;
        }
        return -1;
    }

    private static String[] getPathComponents(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokens.nextToken();
            ++i;
        }
        return result;
    }

    private static String[] getPaths(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        String currentPath = "";
        String pathSep = "";
        int i = 0;
        while (i < result.length) {
            result[i] = currentPath = String.valueOf(currentPath) + pathSep + tokens.nextToken();
            pathSep = File.separator;
            ++i;
        }
        return result;
    }

    public static boolean isAncestorOf(File a, File b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        File ancestor = b.getParentFile();
        while (ancestor != null) {
            if (ancestor.equals(a)) {
                return true;
            }
            ancestor = ancestor.getParentFile();
        }
        return false;
    }

    public static String fromURI(String uri) {
        if (!uri.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        uri = uri.startsWith("file://") ? uri.substring(7) : uri.substring(5);
        uri = uri.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public int compareLastModified(long date, File file) {
        return this.compareLastModified(date, file.lastModified());
    }

    private int compareLastModified(long date1, long date2) {
        long diff = date1 - date2;
        if (Math.abs(diff) <= this.PLATFORM_FS_RESOLUTION / 2L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public static File[] listMatchingFilesForDir(File dir, final String regex) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().matches(regex);
            }
        });
        if (files == null) {
            throw new IOException("Unable to read directory " + dir);
        }
        return files;
    }

    public static File createTempDir(String name) throws IOException {
        return FileUtils.createTempDir(name, null);
    }

    public static File createTempDir(String name, File parent) throws IOException {
        File temp;
        if (parent != null) {
            parent.mkdirs();
            temp = File.createTempFile(name, "", parent);
        } else {
            temp = File.createTempFile(name, "");
        }
        temp.delete();
        temp.mkdirs();
        return temp;
    }

    public static File createEmptyDir(File parent, String name) {
        File emptyDir = new File(parent, name);
        FileUtils.deltree(emptyDir);
        emptyDir.mkdirs();
        return emptyDir;
    }

    public static String readChars(DataInputStream in) throws IOException {
        int len = in.readInt();
        StringBuilder buf = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            buf.append(in.readChar());
            ++i;
        }
        return buf.toString();
    }

    public static File getCurrentDirIfNull(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        return dir;
    }
}

