/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.util.CloverExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CloverExecutors {
    private CloverExecutors() {
    }

    public static CloverExecutor newCloverExecutor(int numThreads, String threadPrefix) {
        return new CloverExecutorService(numThreads, threadPrefix);
    }

    private static class CloverExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CloverExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Logger.getInstance().error(thread.getName(), throwable);
        }
    }

    private static class CloverExecutorService
    implements CloverExecutor {
        private final ExecutorService service;

        public CloverExecutorService(int numThreads, final String threadPrefix) {
            final CloverExceptionHandler handler = new CloverExceptionHandler();
            this.service = numThreads > 0 ? Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setUncaughtExceptionHandler(handler);
                    thread.setName(String.valueOf(threadPrefix) + "-" + thread.getName());
                    return thread;
                }
            }) : null;
        }

        @Override
        public void shutdown() {
            if (this.service != null) {
                this.service.shutdown();
            }
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.service == null || this.service.awaitTermination(timeout, unit);
        }

        @Override
        public void submit(Callable task) throws Exception {
            if (this.service != null) {
                this.service.submit(new LoggingCallable(task));
            } else {
                task.call();
            }
        }
    }

    private static class LoggingCallable
    implements Callable {
        private final Callable task;

        public LoggingCallable(Callable callable) {
            this.task = callable;
        }

        public Object call() throws Exception {
            try {
                return this.task.call();
            }
            catch (Throwable e) {
                Logger.getInstance().warn(e);
                return null;
            }
        }
    }
}

