/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.services;

import com.atlassian.clover.Logger;
import com.atlassian.clover.services.ServiceNotAvailableException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openclover.util.Lists;

public class ServiceLocator<S>
implements Iterable<S> {
    private final Class<S> spi;
    private final List<URL> providers;

    private ServiceLocator(Class<S> spi, List<URL> providers) {
        this.spi = spi;
        this.providers = providers;
    }

    @Override
    public Iterator<S> iterator() {
        final Iterator<URL> providerIterator = this.providers.iterator();
        return new Iterator<S>(){

            @Override
            public boolean hasNext() {
                return providerIterator.hasNext();
            }

            @Override
            public S next() {
                URL provider = (URL)providerIterator.next();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(provider.openStream()));
                    String className = reader.readLine().trim();
                    try {
                        return Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new ServiceNotAvailableException("Failed to instantiate service provider " + className, e);
                    }
                }
                catch (IOException e) {
                    throw new ServiceNotAvailableException("Failed to instantiate service provider for resource " + provider, e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLocator<S> load(Class<S> spi, ClassLoader classLoader) {
        LinkedList<URL> providers = Lists.newLinkedList();
        String serviceResource = "/META-INF/services/" + spi.getName();
        try {
            Enumeration<URL> resources = (classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).getResources(serviceResource);
            while (resources.hasMoreElements()) {
                providers.add(resources.nextElement());
            }
        }
        catch (Exception e) {
            Logger.getInstance().warn("Failed to load service resources " + serviceResource, e);
        }
        return new ServiceLocator<S>(spi, providers);
    }
}

