/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.json.JSONException;
import com.atlassian.clover.reporters.json.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class JSONHistoricalReporter {
    private final File mBasePath;

    public JSONHistoricalReporter(File basePath) {
        this.mBasePath = basePath;
    }

    public void generateHistoricalJSON(VelocityContext context, Map<Long, HasMetrics> data, String title) throws Exception {
        JSONObject json = this.generateJSON(data, title);
        File jsonOutfile = new File(this.mBasePath, "historical-json.js");
        context.put("json", json.toString(2));
        context.put("callback", "processHistoricalCloverData");
        Logger.getInstance().info("Writing JSON historical-data to: " + jsonOutfile);
        HtmlReportUtil.mergeTemplateToFile(jsonOutfile, context, "api-json.vm");
    }

    JSONObject generateJSON(Map<Long, HasMetrics> data, String title) throws JSONException {
        JSONObject json = new JSONObject();
        HashMap table = Maps.newHashMap();
        LinkedList<Map<String, String>> cols = Lists.newLinkedList();
        LinkedList rows = Lists.newLinkedList();
        table.put("cols", cols);
        table.put("rows", rows);
        json.put("name", title);
        json.append("table", table);
        this.addColumnInfo(cols, "timestamp", "Date", "date");
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        List<Column> columns = Columns.getAllColumns();
        for (Column column : columns) {
            this.addColumnInfo(cols, column.getName(), column.getTitle(), "number");
        }
        for (Map.Entry entry : data.entrySet()) {
            HasMetrics hasMetrics = (HasMetrics)entry.getValue();
            Long timestamp = (Long)entry.getKey();
            HashMap rowData = Maps.newHashMap();
            rows.add(rowData);
            LinkedList<Map<String, Object>> row = Lists.newLinkedList();
            rowData.put("c", row);
            this.addRowInfo(row, new Date(timestamp), dateFormat.format(timestamp));
            this.addColumnData(columns, hasMetrics, row);
        }
        return json;
    }

    private void addColumnData(List<Column> columns, HasMetrics hasMetrics, List<Map<String, Object>> row) {
        for (Column column : columns) {
            try {
                column.init(hasMetrics.getMetrics());
            }
            catch (CloverException e) {
                Logger.getInstance().debug("Skipping data for column: " + column.getName(), e);
                continue;
            }
            this.addRowInfo(row, column.getNumber(), column.getFormat().format(column.getColumnData()));
        }
    }

    private void addRowInfo(List<Map<String, Object>> row, Object value, String fmtValue) {
        HashMap rowInfo = Maps.newHashMap();
        rowInfo.put("v", value);
        rowInfo.put("f", fmtValue);
        row.add(rowInfo);
    }

    private void addColumnInfo(List<Map<String, String>> cols, String id, String label, String type) {
        HashMap colInfo = Maps.newHashMap();
        colInfo.put("id", id);
        colInfo.put("label", label);
        colInfo.put("type", type);
        cols.add(colInfo);
    }
}

