/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.registry.CorruptedRegistryException;
import com.atlassian.clover.registry.IncompatibleRegistryFormatException;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.BufferUtils;
import com.atlassian.clover.registry.format.RegAccessMode;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.Adler32;

public class RegHeader {
    public static final long REG_MAGIC = -889258259L;
    public static final int REG_FORMAT_VERSION = 40502;
    public static final int MAX_NAME_LENGTH = 64;
    public static final int SIZE = 308;
    private final RegAccessMode accessMode;
    private final long version;
    private final int slotCount;
    private final long coverageLocation;
    private final long lastSessionLocation;
    private final String name;

    RegHeader(RegAccessMode accessMode, long version, int slotCount, long coverageLocation, long lastSessionLocation, String name) {
        this.accessMode = accessMode;
        this.version = version;
        this.slotCount = slotCount;
        this.coverageLocation = coverageLocation;
        this.lastSessionLocation = lastSessionLocation;
        this.name = name;
    }

    public RegAccessMode getAccessMode() {
        return this.accessMode;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public long getVersion() {
        return this.version;
    }

    public long getLastSessionLocation() {
        return this.lastSessionLocation;
    }

    public long getCoverageLocation() {
        return this.coverageLocation;
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegHeader readFrom(File registryFile) throws IOException, RegistryFormatException {
        try (DataInputStream stream = new DataInputStream(Files.newInputStream(registryFile.toPath(), new OpenOption[0]));){
            RegHeader regHeader = RegHeader.readFrom(new StreamInputSource(registryFile.getAbsolutePath(), stream));
            return regHeader;
        }
        catch (EOFException e) {
            throw new CorruptedRegistryException("The Clover registry file \"" + registryFile.getAbsolutePath() + "\" is invalid (truncated header). Please regenerate.");
        }
    }

    public static RegHeader readFrom(String name, FileChannel channel) throws IOException, RegistryFormatException {
        try {
            return RegHeader.readFrom(new BufferInputSource(name, BufferUtils.readFully(channel, ByteBuffer.allocate(308))));
        }
        catch (BufferUnderflowException e) {
            throw new CorruptedRegistryException("The Clover registry file \"" + name + "\" is invalid (truncated header). Please regenerate.");
        }
    }

    protected static RegHeader readFrom(HeaderInputSource dis) throws IOException, RegistryFormatException {
        long magic = dis.getLong();
        if (-889258259L != magic) {
            throw new CorruptedRegistryException("File \"" + dis.getName() + "\" is not a valid Clover registry file (file magic number invalid - expected 0x" + Integer.toHexString(-889258259) + " but was 0x" + Integer.toHexString((int)magic) + "). Please regenerate.");
        }
        int regFormat = dis.getInt();
        if (40502 != regFormat) {
            throw new IncompatibleRegistryFormatException("Clover is no longer compatible with the registry file \"" + dis.getName() + "\" (format version " + regFormat + ", supported " + 40502 + "). Please regenerate.");
        }
        Adler32 checksum = new Adler32();
        int mode = dis.getInt(checksum);
        long version = dis.getLong(checksum);
        int slotCount = dis.getInt(checksum);
        long coverageLocation = dis.getLong(checksum);
        long lastSessionLocation = dis.getLong(checksum);
        char[] name = new char[64];
        for (int i = 0; i < name.length; ++i) {
            name[i] = dis.getChar(checksum);
        }
        if (dis.getLong() != checksum.getValue()) {
            throw new CorruptedRegistryException("Clover registry File \"" + dis.getName() + "\" may have been corrupted (header checksum incorrect). Please regenerate.");
        }
        return new RegHeader(RegAccessMode.getFor(mode), version, slotCount, coverageLocation, lastSessionLocation, new String(name).trim());
    }

    public void write(FileChannel channel) throws IOException {
        char[] chars;
        ByteBuffer buffer = ByteBuffer.allocate(308);
        buffer.putLong(-889258259L);
        buffer.putInt(40502);
        Adler32 checksum = new Adler32();
        BufferUtils.putWithChecksum(buffer, this.accessMode.getValue(), checksum);
        BufferUtils.putWithChecksum(buffer, this.version, checksum);
        BufferUtils.putWithChecksum(buffer, this.slotCount, checksum);
        BufferUtils.putWithChecksum(buffer, this.coverageLocation, checksum);
        BufferUtils.putWithChecksum(buffer, this.lastSessionLocation, checksum);
        for (char oneChar : chars = String.format("%-64.64s", this.name).toCharArray()) {
            BufferUtils.putWithChecksum(buffer, oneChar, checksum);
        }
        buffer.putLong(checksum.getValue());
        buffer.flip();
        BufferUtils.writeFully(channel, buffer);
    }

    private static class StreamInputSource
    implements HeaderInputSource {
        private final DataInputStream dis;
        private final String name;

        private StreamInputSource(String name, DataInputStream dis) {
            this.name = name;
            this.dis = dis;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getLong() throws IOException {
            return this.dis.readLong();
        }

        @Override
        public int getInt() throws IOException {
            return this.dis.readInt();
        }

        @Override
        public long getLong(Adler32 checksum) throws IOException {
            long result = this.dis.readLong();
            checksum.update((int)(result & 0xFFFFL));
            checksum.update((int)(result >> 32));
            return result;
        }

        @Override
        public int getInt(Adler32 checksum) throws IOException {
            int result = this.dis.readInt();
            checksum.update(result);
            return result;
        }

        @Override
        public char getChar(Adler32 checksum) throws IOException {
            return (char)this.getInt(checksum);
        }
    }

    private static class BufferInputSource
    implements HeaderInputSource {
        private final String name;
        private final ByteBuffer buffer;

        private BufferInputSource(String name, ByteBuffer buffer) {
            this.name = name;
            this.buffer = buffer;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong(Adler32 checksum) {
            return BufferUtils.getLongWithChecksum(this.buffer, checksum);
        }

        @Override
        public int getInt(Adler32 checksum) {
            return BufferUtils.getIntWithChecksum(this.buffer, checksum);
        }

        @Override
        public char getChar(Adler32 checksum) {
            return (char)BufferUtils.getIntWithChecksum(this.buffer, checksum);
        }
    }

    private static interface HeaderInputSource {
        public String getName();

        public long getLong() throws IOException;

        public int getInt() throws IOException;

        public long getLong(Adler32 var1) throws IOException;

        public int getInt(Adler32 var1) throws IOException;

        public char getChar(Adler32 var1) throws IOException;
    }
}

