/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.format.CoverageSegment;
import com.atlassian.clover.registry.format.InaccessibleRegFileException;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.RegHeader;
import com.atlassian.clover.registry.format.UpdatableRegFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import org.openclover.util.Lists;

public class FreshRegFile
extends RegFile<UpdatableRegFile> {
    private final RegAccessMode accessMode;
    private final String name;
    private final CoverageSegment coverageSegment;

    public FreshRegFile(File file, RegAccessMode accessMode, String name, CoverageData coverageData) {
        super(file);
        this.accessMode = accessMode;
        this.name = name;
        this.coverageSegment = coverageData == null ? null : new CoverageSegment(coverageData);
    }

    public FreshRegFile(File file, RegAccessMode accessMode, String name) {
        this(file, accessMode, name, null);
    }

    public FreshRegFile(RegFile regFile, CoverageData coverageData) {
        this(regFile.getFile(), regFile.getAccessMode(), regFile.getName(), coverageData);
    }

    private static File ensureFileAccessible(File file) throws InaccessibleRegFileException {
        File absFile = file.getAbsoluteFile();
        if (absFile.exists() && (!absFile.canWrite() || absFile.isDirectory())) {
            throw new InaccessibleRegFileException("Clover registry file: " + absFile.getAbsolutePath() + " already exists but cannot be overwritten or is a directory.");
        }
        if (!absFile.exists() && absFile.getParentFile() != null && absFile.getParentFile().exists() && !absFile.getParentFile().canWrite()) {
            throw new InaccessibleRegFileException("Clover registry file: " + absFile.getAbsolutePath() + " cannot be written to (parent directory doesn't exist or can't be written to).");
        }
        return file;
    }

    @Override
    protected UpdatableRegFile saveImpl(List<? extends RegistryUpdate> deltas) throws IOException, CloverRegistryException {
        if (deltas.size() == 0) {
            throw new IllegalArgumentException("At least one registry update is required for saving");
        }
        File registryFile = FreshRegFile.ensureFileAccessible(this.getFile());
        File tmpfile = new File(registryFile.getParentFile(), String.valueOf(registryFile.getName()) + ".tmp");
        File tmpParentFile = tmpfile.getParentFile();
        if (tmpParentFile != null) {
            tmpParentFile.mkdirs();
        }
        tmpfile.delete();
        long finalVersion = deltas.get(deltas.size() - 1).getVersion();
        LinkedList sessions = Lists.newLinkedList();
        RegHeader header = new RegHeader(this.accessMode, finalVersion, 0, -1L, -1L, this.getName());
        Throwable throwable = null;
        Object var10_10 = null;
        try (RandomAccessFile file = new RandomAccessFile(tmpfile, "rw");){
            long covLoc;
            FileChannel channel = file.getChannel();
            channel.position(0L);
            header.write(channel);
            if (this.coverageSegment != null) {
                this.coverageSegment.write(channel);
                covLoc = channel.position() - 1L;
            } else {
                covLoc = -1L;
            }
            int maxSlotLength = 0;
            for (RegistryUpdate registryUpdate : deltas) {
                maxSlotLength = Math.max(maxSlotLength, registryUpdate.getSlotCount());
                InstrSessionSegment session = new InstrSessionSegment(registryUpdate.getVersion(), registryUpdate.getStartTs(), registryUpdate.getEndTs(), this.toRecords(registryUpdate.getFileInfos()), registryUpdate.getContextStore());
                session.write(channel);
                sessions.add(session);
            }
            header = new RegHeader(this.accessMode, finalVersion, maxSlotLength, covLoc, channel.position() - 1L, this.getName());
            channel.position(0L);
            header.write(channel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (registryFile.exists() && !registryFile.delete()) {
            throw new IOException("Can't delete existing registry file " + registryFile);
        }
        if (!tmpfile.renameTo(registryFile)) {
            throw new IOException("Failed to move tmp registry file " + tmpfile + " to final registry file");
        }
        registryFile.setLastModified(finalVersion);
        return new UpdatableRegFile(this.getFile(), header);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RegAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public boolean isAppendable() {
        return false;
    }
}

