/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.StackTraceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;

public class LineInfo {
    public static Comparator<ElementInfo> COLUMN_COMPARATOR = new Comparator<ElementInfo>(){

        @Override
        public int compare(ElementInfo a, ElementInfo b) {
            return Integer.compare(a.getStartColumn(), b.getStartColumn());
        }
    };
    private int line;
    private static final FullClassInfo[] EMPTY_CLASS_INFOS = new FullClassInfo[0];
    private static final FullMethodInfo[] EMPTY_METHOD_INFOS = new FullMethodInfo[0];
    private static final FullStatementInfo[] EMPTY_STATEMENT_INFOS = new FullStatementInfo[0];
    private static final FullBranchInfo[] EMPTY_BRANCH_INFOS = new FullBranchInfo[0];
    private List<FullClassInfo> classStarts;
    private List<FullMethodInfo> methodStarts;
    private List<FullStatementInfo> statements;
    private List<FullBranchInfo> branches;
    private StackTraceInfo.TraceEntry[] failStackEntries;

    public LineInfo(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @NotNull
    public List<FullElementInfo> getColumnOrderedElementInfos() {
        ArrayList<FullElementInfo> elements = Lists.newArrayList();
        if (this.methodStarts != null) {
            elements.addAll(this.methodStarts);
        }
        if (this.statements != null) {
            elements.addAll(this.statements);
        }
        if (this.branches != null) {
            elements.addAll(this.branches);
        }
        Collections.sort(elements, COLUMN_COMPARATOR);
        return elements;
    }

    @NotNull
    public FullClassInfo[] getClassStarts() {
        if (this.classStarts == null) {
            return EMPTY_CLASS_INFOS;
        }
        return this.classStarts.toArray(new FullClassInfo[0]);
    }

    @NotNull
    public FullMethodInfo[] getMethodStarts() {
        if (this.methodStarts == null) {
            return EMPTY_METHOD_INFOS;
        }
        return this.methodStarts.toArray(new FullMethodInfo[0]);
    }

    @NotNull
    public FullStatementInfo[] getStatements() {
        if (this.statements == null) {
            return EMPTY_STATEMENT_INFOS;
        }
        return this.statements.toArray(new FullStatementInfo[0]);
    }

    @NotNull
    public FullBranchInfo[] getBranches() {
        if (this.branches == null) {
            return EMPTY_BRANCH_INFOS;
        }
        return this.branches.toArray(new FullBranchInfo[0]);
    }

    public StackTraceInfo.TraceEntry[] getFailStackEntries() {
        return this.failStackEntries;
    }

    void addClassStart(FullClassInfo clazz) {
        if (this.classStarts == null) {
            this.classStarts = Lists.newArrayList();
        }
        this.classStarts.add(clazz);
    }

    void addMethodStart(FullMethodInfo method) {
        if (this.methodStarts == null) {
            this.methodStarts = Lists.newArrayList();
        }
        this.methodStarts.add(method);
    }

    void addStatement(FullStatementInfo stmt) {
        if (this.statements == null) {
            this.statements = Lists.newArrayList();
        }
        this.statements.add(stmt);
    }

    void addBranch(FullBranchInfo branch) {
        if (this.branches == null) {
            this.branches = Lists.newArrayList();
        }
        this.branches.add(branch);
    }

    public void setFailStackEntries(StackTraceInfo.TraceEntry[] entries) {
        this.failStackEntries = new StackTraceInfo.TraceEntry[entries.length];
        System.arraycopy(entries, 0, this.failStackEntries, 0, entries.length);
    }

    public boolean hasMethodStarts() {
        return this.methodStarts != null;
    }

    public boolean hasClassStarts() {
        return this.classStarts != null;
    }

    public boolean hasFailStackEntries() {
        return this.failStackEntries != null;
    }

    public boolean hasBranches() {
        return this.branches != null;
    }

    public boolean hasStatements() {
        return this.statements != null;
    }
}

