/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Languages;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BasicElementInfo;
import com.atlassian.clover.registry.entities.BasicStatementInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.ParentEntity;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class FullStatementInfo
extends FullElementInfo<BasicElementInfo>
implements TaggedPersistent,
StatementInfo {
    private transient ParentEntity parent;

    public FullStatementInfo(FullMethodInfo containingMethod, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, int complexity) {
        this(containingMethod, relativeDataIndex, context, region, complexity, LanguageConstruct.Builtin.STATEMENT);
    }

    public FullStatementInfo(FullMethodInfo containingMethod, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, int complexity, LanguageConstruct construct) {
        this(containingMethod, context, (BasicElementInfo)new BasicStatementInfo(region, relativeDataIndex, complexity, construct));
    }

    private FullStatementInfo(int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, int complexity, LanguageConstruct construct) {
        this((ParentEntity)null, context, (BasicElementInfo)new BasicStatementInfo(region, relativeDataIndex, complexity, construct));
    }

    public FullStatementInfo(FullMethodInfo containingMethod, com.atlassian.clover.api.registry.ContextSet context, BasicElementInfo sharedInfo) {
        this(new ParentEntity(containingMethod), context, sharedInfo);
    }

    public FullStatementInfo(FullClassInfo containingClass, com.atlassian.clover.api.registry.ContextSet context, BasicElementInfo sharedInfo) {
        this(new ParentEntity(containingClass), context, sharedInfo);
    }

    public FullStatementInfo(FullFileInfo containingFile, com.atlassian.clover.api.registry.ContextSet context, BasicElementInfo sharedInfo) {
        this(new ParentEntity(containingFile), context, sharedInfo);
    }

    private FullStatementInfo(ParentEntity parent, com.atlassian.clover.api.registry.ContextSet context, BasicElementInfo sharedInfo) {
        super(context, sharedInfo);
        this.parent = parent;
    }

    public FullStatementInfo copy(FullMethodInfo parentMethod) {
        return new FullStatementInfo(parentMethod, this.context, this.sharedInfo);
    }

    public FullStatementInfo copy(FullClassInfo parentClass) {
        return new FullStatementInfo(parentClass, this.context, this.sharedInfo);
    }

    public FullStatementInfo copy(FullFileInfo parentFile) {
        return new FullStatementInfo(parentFile, this.context, this.sharedInfo);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        throw new UnsupportedOperationException("setDataProvider not supported on FullStatementInfo");
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        final AtomicReference dataProvider = new AtomicReference();
        this.parent.getParentEntity().visit(new EntityVisitor(){

            @Override
            public void visitFile(FileInfo parentFile) {
                dataProvider.set(((CoverageDataReceptor)((Object)parentFile)).getDataProvider());
            }

            @Override
            public void visitClass(ClassInfo parentClass) {
                dataProvider.set(((CoverageDataReceptor)((Object)parentClass)).getDataProvider());
            }

            @Override
            public void visitMethod(MethodInfo parentMethod) {
                dataProvider.set(((CoverageDataReceptor)((Object)parentMethod)).getDataProvider());
            }
        });
        return (CoverageDataProvider)dataProvider.get();
    }

    @Override
    public int getDataLength() {
        return 1;
    }

    protected void setContainingClass(FullClassInfo containingClass) {
        this.parent = new ParentEntity(containingClass);
    }

    protected void setContainingMethod(FullMethodInfo methodInfo) {
        this.parent = new ParentEntity(methodInfo);
    }

    protected void setContainingFile(FullFileInfo containingFile) {
        if (this.parent != null) {
            this.parent.setContainingFile(containingFile);
        } else {
            this.parent = new ParentEntity(containingFile);
        }
    }

    @Nullable
    public ClassInfo getContainingClass() {
        return this.parent.getContainingClass();
    }

    @Nullable
    public MethodInfo getContainingMethod() {
        return this.parent.getContainingMethod();
    }

    @Override
    @Nullable
    public FileInfo getContainingFile() {
        return this.parent.getContainingFile();
    }

    @Override
    public EntityContainer getParent() {
        return this.parent.getParentEntity();
    }

    public String toString() {
        return "FullStatementInfo{sharedInfo=" + this.sharedInfo + ", context=" + this.context + '}';
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.write(ContextSet.class, (ContextSet)this.context);
        out.writeInt(this.sharedInfo.getRelativeDataIndex());
        out.writeInt(this.getComplexity());
        out.writeUTF(this.sharedInfo.getConstruct().getId());
        FixedSourceRegion.writeRaw(this, out);
    }

    public static FullStatementInfo read(TaggedDataInput in) throws IOException {
        com.atlassian.clover.api.registry.ContextSet context = in.read(ContextSet.class);
        int relativeDataIndex = in.readInt();
        int complexity = in.readInt();
        LanguageConstruct construct = Languages.lookupConstruct(in.readUTF());
        FixedSourceRegion region = FixedSourceRegion.read(in);
        return new FullStatementInfo(relativeDataIndex, context, region, complexity, construct);
    }
}

