/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.registry.AnnotationValueCollection;
import com.atlassian.clover.registry.PersistentAnnotationValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Maps;

public class AnnotationImpl
implements Annotation,
PersistentAnnotationValue,
AnnotationValueCollection {
    @NotNull
    private String name = "";
    @NotNull
    private Map<String, PersistentAnnotationValue> attributes = Maps.newHashMap();

    public AnnotationImpl() {
    }

    public AnnotationImpl(@NotNull String name) {
        this.name = name;
    }

    public AnnotationImpl(Annotation annotation) {
        this.name = annotation.getName();
        for (Map.Entry<String, AnnotationValue> entry : annotation.getAttributes().entrySet()) {
            this.put(entry.getKey(), (PersistentAnnotationValue)entry.getValue());
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public Map<String, AnnotationValue> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void put(String attributeName, PersistentAnnotationValue value) {
        this.attributes.put(attributeName, value);
    }

    @Override
    @Nullable
    public AnnotationValue getAttribute(@NotNull String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    @NotNull
    public List<? extends AnnotationValue> toList() {
        return Collections.singletonList(this);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.name);
        Set<Map.Entry<String, PersistentAnnotationValue>> entries = this.attributes.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<String, PersistentAnnotationValue> entry : entries) {
            out.writeUTF(entry.getKey());
            out.write(entry.getValue().getClass(), entry.getValue());
        }
    }

    public static AnnotationImpl read(TaggedDataInput in) throws IOException {
        AnnotationImpl annotation = new AnnotationImpl(in.readUTF());
        int numEntries = in.readInt();
        int i = 0;
        while (i < numEntries) {
            annotation.put(in.readUTF(), in.read(PersistentAnnotationValue.class));
            ++i;
        }
        return annotation;
    }

    public String toString() {
        return "AnnotationImpl{name='" + this.name + '\'' + ", attributes=" + this.attributes + '}';
    }
}

