/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder.junit;

import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.TestNameSnifferHelper;
import com_atlassian_clover.TestNameSniffer;
import junit.runner.TestRunListener;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class JUnitTestRunnerInterceptor
extends RunListener
implements TestRunListener {
    public void testStarted(Description description) {
        TestNameSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test started: \"" + description.getDisplayName() + "\"");
        Class testClass = description.getTestClass();
        if (testClass != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.setTestName(description.getDisplayName());
        }
    }

    public void testFinished(Description description) {
        TestNameSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + description.getDisplayName() + "\"");
        Class testClass = description.getTestClass();
        if (testClass != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.clearTestName();
        }
    }

    public void testStarted(String testName) {
        TestNameSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + testName + "\"");
        Class testClass = this.getTestClass(testName);
        if (testClass != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.setTestName(testName);
        }
    }

    public void testEnded(String testName) {
        TestNameSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + testName + "\"");
        Class testClass = this.getTestClass(testName);
        if (testClass != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.clearTestName();
        }
    }

    protected Class getTestClass(String testName) {
        int classNameEnd = testName.lastIndexOf(".");
        if (classNameEnd > 0) {
            String className = testName.substring(0, classNameEnd);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logger.getInstance().debug("Unable to find class '" + className + "'. Clover cannot inject the current test name into coverage recorder.");
            }
        } else {
            Logger.getInstance().debug("Unknown class name for a test. Clover cannot inject the current test name into coverage recorder");
        }
        return null;
    }

    public void testRunStarted(String testSuiteName, int testCount) {
    }

    public void testRunEnded(long elapsedTime) {
    }

    public void testRunStopped(long elapsedTime) {
    }

    public void testFailed(int status, String testName, String trace) {
    }
}

