/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder.junit;

import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.TestNameSnifferHelper;
import com_atlassian_clover.TestNameSniffer;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class CloverJUnit5TestExecutionListener
implements TestExecutionListener {
    private TestPlan testPlan;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        Logger.getInstance().debug("CloverJUnit5TestExecutionListener: JUnit test started: \"" + testIdentifier.getDisplayName() + "\"");
        if (testIdentifier.isTest()) {
            TestNameSniffer junitSniffer;
            String testName = testIdentifier.getDisplayName();
            Class testClass = CloverJUnit5TestExecutionListener.findTestMethodClass(this.testPlan, testIdentifier);
            if (testClass != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
                junitSniffer.setTestName(testName);
            }
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestNameSniffer junitSniffer;
        Class testClass;
        Logger.getInstance().debug("CloverJUnit5TestExecutionListener: JUnit test ended: \"" + testIdentifier.getDisplayName() + "\"");
        if (testIdentifier.isTest() && (testClass = CloverJUnit5TestExecutionListener.findTestMethodClass(this.testPlan, testIdentifier)) != null && (junitSniffer = TestNameSnifferHelper.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.clearTestName();
        }
    }

    private static Class findTestMethodClass(TestPlan testPlan, TestIdentifier identifier) {
        Class javaClass = CloverJUnit5TestExecutionListener.fromMethodSource(identifier);
        if (javaClass != null) {
            return javaClass;
        }
        javaClass = CloverJUnit5TestExecutionListener.fromClassSource(identifier);
        if (javaClass != null) {
            return javaClass;
        }
        TestIdentifier iter = identifier;
        while (testPlan.getParent(iter).isPresent()) {
            javaClass = CloverJUnit5TestExecutionListener.fromClassSource(iter);
            if (javaClass != null) {
                return javaClass;
            }
            iter = (TestIdentifier)testPlan.getParent(iter).get();
        }
        return null;
    }

    private static Class fromMethodSource(TestIdentifier identifier) {
        Optional source = identifier.getSource();
        if (source.isPresent() && source.get() instanceof MethodSource) {
            try {
                return Class.forName(((MethodSource)source.get()).getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private static Class fromClassSource(TestIdentifier identifier) {
        Optional source = identifier.getSource();
        if (source.isPresent() && source.get() instanceof ClassSource) {
            try {
                return ((ClassSource)source.get()).getJavaClass();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

