/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.recorder.BaseCoverageRecorder;
import com.atlassian.clover.recorder.CoverageSnapshot;
import com.atlassian.clover.recorder.GlobalRecordingWriteStrategy;
import com.atlassian.clover.recorder.PerTestRecorder;
import com.atlassian.clover.util.CloverBitSet;
import com_atlassian_clover.CoverageRecorder;
import java.io.IOException;

public class GrowableCoverageRecorder
extends BaseCoverageRecorder {
    private volatile CoverageMatrix coverage;

    public static CoverageRecorder createFor(String dbName, long dbVersion, long cfgbits, int maxNumElements) {
        return new GrowableCoverageRecorder(dbName, dbVersion, cfgbits, maxNumElements).withCapacityFor(maxNumElements);
    }

    GrowableCoverageRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements) {
        this(dbName, dbVersion, cfgbits, maxNumElements, GlobalRecordingWriteStrategy.WRITE_TO_FILE);
    }

    GrowableCoverageRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements, GlobalRecordingWriteStrategy writeStrategy) {
        super(dbName, dbVersion, cfgbits, writeStrategy);
        this.coverage = new CoverageMatrix(maxNumElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String write() throws IOException {
        int elementCount;
        int[][] hits;
        GrowableCoverageRecorder growableCoverageRecorder = this;
        synchronized (growableCoverageRecorder) {
            hits = this.coverage.getHits();
            elementCount = this.coverage.getNumElements();
        }
        return this.write(hits, elementCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloverBitSet compareCoverageWith(CoverageSnapshot before) {
        int elementCount;
        int[][] hits;
        GrowableCoverageRecorder growableCoverageRecorder = this;
        synchronized (growableCoverageRecorder) {
            hits = this.coverage.getHits();
            elementCount = this.coverage.getNumElements();
        }
        Object beforeHits = before.getCoverage();
        if (hits.length > ((int[][])beforeHits).length) {
            int[][] expandedBeforeHits = new int[hits.length][];
            System.arraycopy(beforeHits, 0, expandedBeforeHits, 0, ((int[][])beforeHits).length);
            for (int i = ((int[][])beforeHits).length; i < expandedBeforeHits.length; ++i) {
                expandedBeforeHits[i] = new int[hits[i].length];
            }
            beforeHits = expandedBeforeHits;
        }
        for (int i = 0; i < hits.length; ++i) {
            int[] row = hits[i];
            int[] beforeRow = beforeHits[i];
            for (int j = 0; j < row.length; ++j) {
                beforeRow[j] = beforeRow[j] - row[j];
            }
        }
        return CloverBitSet.forHits(beforeHits, elementCount);
    }

    @Override
    public CloverBitSet createEmptyHitsMask() {
        return new CloverBitSet(this.coverage.getNumElements());
    }

    @Override
    public int iget(int index) {
        throw new UnsupportedOperationException("void iget(int) should be called on the FixedProxy");
    }

    @Override
    public void inc(int index) {
        throw new UnsupportedOperationException("void inc(int) should be called on the FixedProxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoverageRecorder withCapacityFor(int maxNumElements) {
        GrowableCoverageRecorder growableCoverageRecorder = this;
        synchronized (growableCoverageRecorder) {
            if (maxNumElements > this.coverage.getNumElements()) {
                this.coverage = new CoverageMatrix(this.coverage, maxNumElements);
                return new FixedProxy(this, this.coverage);
            }
            return new FixedProxy(this);
        }
    }

    @Override
    public CoverageSnapshot getCoverageSnapshot() {
        int[][] elements = this.coverage.elements;
        int[][] clone = new int[elements.length][];
        for (int i = 0; i < elements.length; ++i) {
            clone[i] = (int[])elements[i].clone();
        }
        return new CoverageSnapshot(clone);
    }

    public String toString() {
        return "GrowableCoverageRecorder[coverage=" + this.coverage + "]";
    }

    public static final class FixedProxy
    extends CoverageRecorder {
        private final GrowableCoverageRecorder target;
        private final CoverageMatrix coverage;
        private final PerTestRecorder testCoverage;

        FixedProxy(GrowableCoverageRecorder target) {
            this.target = target;
            this.coverage = target.coverage;
            this.testCoverage = target.testCoverage;
        }

        FixedProxy(GrowableCoverageRecorder target, CoverageMatrix coverage) {
            this.target = target;
            this.coverage = coverage;
            this.testCoverage = target.testCoverage;
        }

        @Override
        public int iget(int index) {
            this.testCoverage.set(index);
            return this.coverage.iget(index);
        }

        @Override
        public void inc(int index) {
            this.testCoverage.set(index);
            this.coverage.inc(index);
        }

        @Override
        public CoverageRecorder withCapacityFor(int maxNumElements) {
            if (maxNumElements > this.coverage.getNumElements()) {
                return this.target.withCapacityFor(maxNumElements);
            }
            return this;
        }

        @Override
        public CloverBitSet compareCoverageWith(CoverageSnapshot before) {
            return this.target.compareCoverageWith(before);
        }

        @Override
        public CoverageSnapshot getCoverageSnapshot() {
            return this.target.getCoverageSnapshot();
        }

        @Override
        public CloverBitSet createEmptyHitsMask() {
            return this.target.createEmptyHitsMask();
        }

        @Override
        public void flush() {
            this.target.flush();
        }

        @Override
        public void flushNeeded() {
            this.target.flushNeeded();
        }

        @Override
        public void forceFlush() {
            this.target.forceFlush();
        }

        @Override
        public String getDbName() {
            return this.target.getDbName();
        }

        @Override
        public long getDbVersion() {
            return this.target.getDbVersion();
        }

        @Override
        public String getRecordingName() {
            return this.target.getRecordingName();
        }

        public Thread getShutdownFlusher() {
            return this.target.getShutdownFlusher();
        }

        @Override
        public void maybeFlush() {
            this.target.maybeFlush();
        }

        @Override
        public void sliceEnd(String runtimeType, String method, String runtimeTestName, long ts, int id, int rid, int exitStatus, ErrorInfo ei) {
            this.target.sliceEnd(runtimeType, method, runtimeTestName, ts, id, rid, exitStatus, ei);
        }

        @Override
        public void sliceStart(String runtimeType, long ts, int id, int rid) {
            this.target.sliceStart(runtimeType, ts, id, rid);
        }

        @Override
        public void startRun() {
            this.target.startRun();
        }

        public String toString() {
            return "FixedProxy[target=" + this.target + ", coverage=" + this.coverage + "]";
        }

        @Override
        public void globalSliceStart(String runtimeType, int id) {
            this.target.globalSliceStart(runtimeType, id);
        }

        @Override
        public void globalSliceStart(String runtimeType, int id, long startTime) {
            this.target.globalSliceStart(runtimeType, id, startTime);
        }

        @Override
        public void globalSliceEnd(String runtimeType, String method, String runtimeTestName, int id) {
            this.target.globalSliceEnd(runtimeType, method, runtimeTestName, id);
        }

        @Override
        public void globalSliceEnd(String runtimeType, String method, String runtimeTestName, int id, int exitStatus, Throwable throwable) {
            this.target.globalSliceEnd(runtimeType, method, runtimeTestName, id, exitStatus, throwable);
        }
    }

    static class CoverageMatrix {
        static final int WIDTH_EXPONENT = 20;
        static final int WIDTH = 0x100000;
        static final int WIDTH_MOD_MASK = 1048575;
        private final int[][] elements;
        private final int numElements;

        CoverageMatrix(int numElements) {
            this.elements = new int[this.heightFor(null, numElements)][0x100000];
            this.numElements = numElements;
        }

        CoverageMatrix(CoverageMatrix previous, int numElements) {
            this.elements = new int[this.heightFor(previous, numElements)][];
            System.arraycopy(previous.elements, 0, this.elements, 0, previous.elements.length);
            for (int i = previous.elements.length; i < this.elements.length; ++i) {
                this.elements[i] = new int[0x100000];
            }
            this.numElements = numElements;
        }

        int heightFor(CoverageMatrix current, int required) {
            int currentHeight;
            int n = currentHeight = current == null ? 1 : current.elements.length;
            while (currentHeight * 0x100000 < required) {
                currentHeight <<= 1;
            }
            return currentHeight;
        }

        int getNumElements() {
            return this.numElements;
        }

        int[][] getHits() {
            return this.elements;
        }

        int iget(int index) {
            int[] nArray = this.elements[index >> 20];
            int n = index & 0xFFFFF;
            int n2 = nArray[n] + 1;
            nArray[n] = n2;
            return n2;
        }

        void inc(int index) {
            int[] nArray = this.elements[index >> 20];
            int n = index & 0xFFFFF;
            nArray[n] = nArray[n] + 1;
        }

        public int[] toContiguousCoverage() {
            int[] contiguous = new int[this.numElements];
            for (int i = this.elements.length; i < this.elements.length; ++i) {
                System.arraycopy(this.elements[i], 0, contiguous, i >> 20, 0x100000);
            }
            return contiguous;
        }

        public String toString() {
            return "CoverageMatrix[numElements=" + this.numElements + ", width=" + (this.elements.length == 0 ? 0 : this.elements[0].length) + ", height=" + this.elements.length + "]";
        }
    }
}

