/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.lang;

import com.atlassian.clover.Logger;
import com.atlassian.clover.services.ServiceLocator;
import com.atlassian.clover.services.ServiceNotAvailableException;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class Languages {
    private static final Map<String, LanguageConstruct> LANGUAGE_CONSTRUCTS = Maps.newHashMap();
    private static final Set<Language> LANGUAGES = Sets.newHashSet();

    static {
        Collections.addAll(LANGUAGES, Language.Builtin.values());
        LanguageConstruct.Builtin[] builtinArray = LanguageConstruct.Builtin.values();
        int n = builtinArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageConstruct.Builtin construct = builtinArray[n2];
            LANGUAGE_CONSTRUCTS.put(construct.getId(), construct);
            ++n2;
        }
        for (Language language : ServiceLocator.load(Language.class, Languages.class.getClassLoader())) {
            try {
                LANGUAGES.add(language);
                for (LanguageConstruct construct : language.getSupportedConstructs()) {
                    LANGUAGE_CONSTRUCTS.put(construct.getId(), construct);
                }
            }
            catch (ServiceNotAvailableException e) {
                Logger.getInstance().warn("Failed to register a 3rd party language support", e);
            }
        }
    }

    public static Set<Language> getLanguages() {
        return Collections.unmodifiableSet(LANGUAGES);
    }

    public static LanguageConstruct lookupConstruct(String id) {
        LanguageConstruct construct = LANGUAGE_CONSTRUCTS.get(id);
        if (construct == null) {
            throw new IllegalArgumentException("The language construct with id \"" + id + "\" could not be found.");
        }
        return construct;
    }
}

